% Ex 5: Illumination & Reflectance separation
% This is a part of the tone-mapping workshop 
% (c) 2012 Rafal Mantiuk

%img = hdrread( 'slate_mines.hdr' );
img = hdrread( 'memorial.hdr' );

%%

img_in = img/100;

L_in = get_luminance( img_in );

l = log(L_in);

%I = imfilter( l, fspecial( 'gaussian', 3*10, 10 ) );
I = bilateral_fast( l, 10, 0.3 ); % illuminance
R = l-I; % reflectance

%%

c = 0.6; % contrast
b = -0.4; % brightness
s = 3.3; % sharpness

l_out = s*R + c*I + b;

L_out = exp( l_out );

s = c;

img_out = (img_in ./ repmat( L_in, [1 1 3] )).^s .* repmat( L_out, [1 1 3] );

imshow( cat( 2, lin2srgb( img_in.^c * exp(b) ), lin2srgb( img_out ) ) );





