(* ambients-compiler.ac

  Simple MA -> Acute preprocessor

  Francesco Zappa Nardelli, 2004
*)
(*
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
*)

open Genlex;;
open Filename;;

let gensym =
  let x = ref 0 in
  let gensym_int () =
    x := !x+1; "s_"^(string_of_int !x)
  in gensym_int

let lexer = make_lexer ["["; "]"; "in"; "out"; "open"; "|"; "."; "dump" ; "("; ")"; "<"; ">"; "migrate"; "*"; "(*"; "*)"; ] ;;

let rec parse_simple_proc = parser
    [< 'Int 0 >] -> " ()"

  | [< 'Kwd "in"; 'Ident i; 'Kwd "."; e = parse_simple_proc >] ->
        " Ambients.c_in \""^i^"\" ;"^e

  | [< 'Kwd "out"; 'Ident i; 'Kwd "."; e = parse_simple_proc >] ->
      " Ambients.c_out \""^i^"\" ;"^e

  | [< 'Kwd "open"; 'Ident i; 'Kwd "."; e = parse_simple_proc >] ->
        " Ambients.c_open \""^i^"\" ;"^e

  | [< 'Kwd "migrate"; 'Kwd "<"; 'Int p; 'Kwd ">"; 'Kwd "."; e = parse_simple_proc >] ->
        " Ambients.migrate ((Tcp.ip_of_string \"127.0.0.1\"), (Tcp.port_of_int "^(string_of_int p)^"));\n"^e

  | [< 'Kwd "dump"; 'Kwd "."; e = parse_simple_proc >] ->
      " Ambients.dump_top_level ();"^e

  | [< 'Ident i; 'Kwd "["; e = parse_proc; 'Kwd "]" >] ->
      " Ambients.ambient \""^i^"\" (fun () ->\n "^e^" )"

  | [< 'Kwd "(" ; e = parse_proc ; 'Kwd ")" >] ->
      e

  | [< 'Kwd "*" ; e = parse_simple_proc >] ->
      let x = gensym () in
      " let rec "^x^" () = "^e^"; "^x^"() in "^x^"()"


and parse_more_proc e1 = parser
    [< 'Kwd "|"; e = parse_proc >] ->
      " Ambients.spawn (fun () ->\n "^e1^" ); "^e

  | [< >] -> e1

and parse_proc = parser
    [< e1 = parse_simple_proc; e = parse_more_proc e1 >] -> e

and parse_loc = parser
    [< 'Kwd "<"; 'Int p; 'Kwd ">"; e = parse_proc >] ->
      "Ambients.init (Some(Tcp.ip_of_string \"127.0.0.1\"), Some(Tcp.port_of_int "^(string_of_int p)^"));\n\n"^e

let parse_file = parser [< e = parse_loc; _ = Stream.empty >] -> e

let main () =
  let filename = Sys.argv.(1) in
  if (check_suffix filename "ma") then
    begin
      let s = Stream.of_channel(open_in filename) in
      let l = lexer(s) in
      let comp = parse_file l in
      let out_filename = (chop_extension filename)^".ac" in
      let f_out = open_out out_filename in
        output_string f_out "includesource \"ambients.ac\"\n\n";
        output_string f_out comp;
        close_out f_out
    end
  else
    failwith "usage: amb_compile file.ma"
in
  main ()
