/*
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
*/

#include <stdio.h>
#include <stdlib.h>

#include <mlvalues.h>
#include <alloc.h>
#include <assert.h>
#include <memory.h>
#include <misc.h>


/* should really come from ocaml/byterun/signals.h, but Xavier doesn't install that
   in $(PREFIX)/lib/ocaml/caml when he installs everything else.  Instead, we
   inline the (two) definitions we use here. */
CAMLextern void enter_blocking_section(void);
CAMLextern void leave_blocking_section(void);

char * readline(char *prompt);
void add_history(char *line);

CAMLprim value c_editline(value prompt)
{
  CAMLparam1(prompt);
  CAMLlocal1(u);

  char *s;

  enter_blocking_section();
  s = readline(String_val(prompt));
  leave_blocking_section();

  if (s) {
    add_history(s);
    u = alloc_small(1,0);
    Field(u,0) = copy_string(s);
  } else {
    u = Val_int(0);
  }

  CAMLreturn(u);
}
