(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * Base constructor types (see also Basecon)                      *
 *                                                                *
 * Version: $Id: baseconty.ml,v 1.6 2004/12/22 12:23:31 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)


(* Everything to do with base constructors is defined in these files; to
   add a new one, just extend the relevant definitions. *)

open Basecon
open Ast

let argtyof_B1 : basecon1 -> typ
  = fun c1
 -> match c1 with
    | Fail            -> TTyCon0 TString
    | InvalidArgument -> TTyCon0 TString
    | SysError        -> TTyCon0 TString
    | MatchFail       -> TTup [TTyCon0 TString;TTyCon0 TInt;TTyCon0 TInt]
    | UnmarshalFail   -> TTyCon0 TString
    | ThunkedCVar     -> TTyCon1(TName,TTyCon0 TCVar)
    | ThunkedMutex    -> TTup [TTyCon1(TName,TTyCon0 TMutex);  TTyCon0 TBool]
    | ThunkedThread   -> TTup [TTyCon1(TName,TTyCon0 TThread); TFunc(TTyCon0 TUnit, TTyCon0 TUnit)]
    | CVar            -> TTyCon1(TName,TTyCon0 TCVar )
    | Mutex           -> TTyCon1(TName,TTyCon0 TMutex)
    | Thread          -> TTup [TTyCon1(TName,TTyCon0 TThread); TTyCon0 TThunkifymode]
    | UnixError       -> TTup [TTyCon0 TUnixErrorCode; TTyCon0 TString; TTyCon0 TString]
    | LibraryError    -> TTyCon0 TString

(* --- you shouldn't need to edit below here --- *)

let typeof_B0 : basecon0 -> typ
  = fun c0
 -> TTyCon0 (tyconof_B0 c0)

let typeof_B1 : basecon1 -> (typ * typ)
  = fun c1
 -> (argtyof_B1 c1, TTyCon0 (tyconof_B1 c1))

let dump_tycon0_embedding (tc0 : tycon0) =
  "(eptc0 " ^ tycon0_embedding_fun tc0 ^ ")"

let eptc0 (tc0, ep_to, ep_from) =
  (TTyCon0 tc0,
   (function x -> C0(B0(ep_to x))),
   (function (C0(B0 b0)) -> ep_from b0 | _ -> raise RT_type))

