// This program tries out various methods to find the least significant
// one in a word.
// Implemented in BCPL by Martin Richards (c) Feb 2001

GET "libhdr"

LET start() = VALOF
{ LET t = TABLE //            Cintcode instruction executions
 // test data        result  lsb  lsb1 lsb2 lsb3 lsb4 lsb5 lsb6 lsb7
    #x80000000, // 80000000   4   22   30  288    1   21  106   54 
    #xFF000000, // 01000000   4   22   45  225    1#  21   93   54 
    #x74500000, // 00100000   4   22   45  189    1#  21   80   41 
    #x467C0000, // 00040000   4   22   45  171    1#  21   67   41 
    #x87658000, // 00008000   4   22   35  144    1#  21   54   28 
    #x7FF23400, // 00000400   4   22   45   99    1#  21   41   28 
    #x12345600, // 00000200   4   22   45   90    1#  21   41   28 
    #x0123E000, // 00002000   4   22   40  126    1#  21   54   28 
    #x00123400, // 00000400   4   22   45   99    1#  21   41   28 
    #x00012340, // 00000040   4   22   45   63    1#  21   28   15 
    #x00001204, // 00000004   4   22   50   27    1#  21   15   15 
    #x00000120, // 00000020   4   22   45   54    1#  21   28   15 
    #x00000012, // 00000002   4   22   50   18    1#  21   15   15 
    #x00000001, // 00000001   4   22   55    9    1   21   15   15 
    #xF0F0F0F0, // 00000010   4   22   50   45    1#  21   28   15 
    #x80808000, // 00008000   4   22   35  144    1#  21   54   28 
    #x40400000, // 00400000   4   22   40  207    1#  21   80   41 
    #x20000000, // 20000000   4   22   35  270    1   21  106   54 
    #x10000010, // 00000010   4   22   50   45    1#  21   28   15 
    #x0000FFFF, // 00000001   4   22   55    9    1#  21   15   15 
    #x00001FFF, // 00000001   4   22   55    9    1#  21   15   15 
    #x00000000  // 00000000   4   22    3  293    1   21    3    3 

  LET w = 0
  LET k = 0
  LET bit = 0

  writef("*nTest various implementations of lsb*n*n")

  { w := !t
    t := t+1
    bit := lsb(w)
    writef("%x8 %x8", w, bit)
    try(w, lsb);  try(w, lsb1); try(w, lsb2); try(w, lsb3)
    try(w, lsb4); try(w, lsb5); try(w, lsb6); try(w, lsb7)
    newline()
  } REPEATWHILE w

  writef("*n*nEnd of test*n")
  RESULTIS 0
}

AND try(w, f) BE
  writef(" %i3%c", instrcount(f, w), lsb(w)=f(w) -> ' ', '#')

AND lsb(w) = w & -w

AND lsb1(w) = VALOF
{ w := w | w<<1
  w := w | w<<2
  w := w | w<<4
  w := w | w<<8
  w := w | w<<16
  RESULTIS -w
}

AND lsb2(w) = w=0 -> 0, VALOF
{ LET r, a = #x80000000, ?
  a := w<<16; IF a DO w, r := a, r>>16
  a := w<<8;  IF a DO w, r := a, r>>8
  a := w<<4;  IF a DO w, r := a, r>>4
  a := w<<2;  IF a DO w, r := a, r>>2
  a := w<<1;  IF a DO w, r := a, r>>1
   RESULTIS r
}

AND lsb3(w) = VALOF
{ LET b = 1
  WHILE b DO { UNLESS (w&b)=0 RESULTIS b
               b := b<<1
             }
  RESULTIS 0
}

AND lsb4(w) = w // Intentionally wrong

AND lsb5(w) =
 (w&#x0000ffff)=0 ->
   (w&#x00ff0000)=0 ->
   (w&#x0f000000)=0 -> (w&#x30000000)=0 -> (w&#x40000000)=0 ->          w,
                                                               #x40000000,
                                           (w&#x10000000)=0 -> #x20000000,
                                                               #x10000000,
                       (w&#x03000000)=0 -> (w&#x04000000)=0 -> #x08000000,
                                                               #x04000000,
                                           (w&#x01000000)=0 -> #x02000000,
                                                               #x01000000,
   (w&#x000f0000)=0 -> (w&#x00300000)=0 -> (w&#x00400000)=0 -> #x00800000,
                                                               #x00400000,
                                           (w&#x00100000)=0 -> #x00200000,
                                                               #x00100000,
                       (w&#x00030000)=0 -> (w&#x00040000)=0 -> #x00080000,
                                                               #x00040000,
                                           (w&#x00010000)=0 -> #x00020000,
                                                               #x00010000,
   (w&#x000000ff)=0 ->
   (w&#x00000f00)=0 -> (w&#x00003000)=0 -> (w&#x00004000)=0 -> #x00008000,
                                                               #x00004000,
                                           (w&#x00001000)=0 -> #x00002000,
                                                               #x00001000,
                       (w&#x00000300)=0 -> (w&#x00000400)=0 -> #x00000800,
                                                               #x00000400,
                                           (w&#x00000100)=0 -> #x00000200,
                                                               #x00000100,
   (w&#x0000000f)=0 -> (w&#x00000030)=0 -> (w&#x00000040)=0 -> #x00000080,
                                                               #x00000040,
                                           (w&#x00000010)=0 -> #x00000020,
                                                               #x00000010,
                       (w&#x00000003)=0 -> (w&#x00000004)=0 -> #x00000008,
                                                               #x00000004,
                                           (w&#x00000001)=0 -> #x00000002,
                                                               #x00000001


AND lsb6(w) = w=0 -> 0, VALOF
{ LET s = 0
  LET t = TABLE 0,1,2,1,4,1,2,1,8,1,2,1,4,1,2,1
  { LET b = w&15
    IF b RESULTIS t!b<<s 
    w, s := w>>4, s+4
  } REPEAT
}

AND lsb7(w) = w=0 -> 0, VALOF
{ LET s = 0
  LET t = TABLE  0,1,2,1,4,1,2,1,8,1,2,1,4,1,2,1,
                16,1,2,1,4,1,2,1,8,1,2,1,4,1,2,1,
                32,1,2,1,4,1,2,1,8,1,2,1,4,1,2,1,
                16,1,2,1,4,1,2,1,8,1,2,1,4,1,2,1,
                64,1,2,1,4,1,2,1,8,1,2,1,4,1,2,1,
                16,1,2,1,4,1,2,1,8,1,2,1,4,1,2,1,
                32,1,2,1,4,1,2,1,8,1,2,1,4,1,2,1,
                16,1,2,1,4,1,2,1,8,1,2,1,4,1,2,1,
               128,1,2,1,4,1,2,1,8,1,2,1,4,1,2,1,
                16,1,2,1,4,1,2,1,8,1,2,1,4,1,2,1,
                32,1,2,1,4,1,2,1,8,1,2,1,4,1,2,1,
                16,1,2,1,4,1,2,1,8,1,2,1,4,1,2,1,
                64,1,2,1,4,1,2,1,8,1,2,1,4,1,2,1,
                16,1,2,1,4,1,2,1,8,1,2,1,4,1,2,1,
                32,1,2,1,4,1,2,1,8,1,2,1,4,1,2,1,
                16,1,2,1,4,1,2,1,8,1,2,1,4,1,2,1

  { LET b = w&255
    IF b RESULTIS t!b<<s 
    w, s := w>>8, s+8
  } REPEAT
}
