/*
This is the header file for the graphics library com/graphics.b

Implemented by Martin Richards (c) 9 December 2011

The default setting of the manifest g_grfbase=400 is defined in
libhdr.h, but can be overridden by a later definition.

History

28/07/2020
The grphics library has just had a major somewhat incompatible revision.
It can now images using eithe 8 or 24 bite pixels in BMP format. The user can
select one of two builtin palettes in 8 bit pixels are used. Of course there
is no need for a palette when using 24 bit pixels. The variables plotx, ploty
and plotcolour have been renamed currx, curry and currcolour. The arguments for
opengraphics, plotrect, plotfilrect, plotcircle and plotfilcircle have changed
making more use of currx, curry and currcolour. The names of the builtin
colours have chaged.
*/

GLOBAL {
opengraphics: g_grbase  // (xmax, ymax, mode)
closegraphics           // ()

canvas      // Rectangular array of pixel bytes
canvassize  // Number of bytes in canvas
canvasupb   // UPB of canvas in words
xsize
ysize

bmpmode     // = mode8bit, mode8bitalt, mode24bit
bpp         // bytes per pixel, either 1 or 3

palettev    // Vector for the palette when bmpmode is mode3bit or mode8bitalt

col_white
col_majenta
col_blue
col_cyan
col_green
col_yellow
col_red
col_black

currx         // Current x position
curry         // Cyrrent y position
currcolour    // Current colour. If bmpmode is not mode24 it is the 8-bit
              // subscript of a colour in the palette, otherwise it is an
              // explicit colour of the form #Xrrggbb.
rowlen        // xsize in bytes = bpp*xsize

setcolour     // (col)             Set the current colour in currcolour
drawpoint     // (x,y)             Draw a point using currcolour
drawpoint33   // (x,y)             Draw a 3x3 filled square using currcolour

drawch        // (ch)              Draw a character
drawstr       // (x,y,s)           Draw a string
drawf         // (x,y,format,<args>)
drawwrch      // (ch)              The version of wrch used by drawf
drawfstr      //                   Used by drawwch
moveto        // (x,y)             Set the current position
moveby        // (dx,dy)           Increment the current position
drawto        // (x,y)             Draw a line from the current position
drawby        // (dx,dy)           Draw a line given its position increment
drawrect      // (x,y,w,h)         Draw a rectangle of width w and height h
              //                   with bottom left corner at (x,y) using currcolour.
drawfillrect  // (x,y,w,h)         Draw a filled rectangle of width w and height h
              //                   with bottom left corner at (x,y) using currcolour.
drawrndrect   // ((x,y,w,h,radius) Draw a rectangle with rounded corners of width w
              //                   and height h with bottom left corner at (x,y)
	      //                   using currcolour.
fillrndrect   // ((x,y,radius)     Draw a filled rectangle with rounded corners
              //                   of width w and height h with bottom left corner
	      //                   at (x,y) using currcolour.
drawcircle    // (x,y,radius)      Draw a circle with centre (x,y) and given radius.
fillcircle    // (x,y,radius)      Draw a filled circle with centre (x,y) and
              //                   given radius.
wrgraph       // (filename)        Output the image as a .bpm file.
}

MANIFEST {
  mode8bit=1000  // For 8 bit pbm using the palette generated by initpalette
  mode8bitalt    // For 8 bit pbm using the palette generated by initpalettealt
  mode24bit      // For 24 bit pbm with no palette
}

