(*  Title:      Relation.thy
    ID:         $Id: Relation.thy,v 1.8 1998/01/08 16:56:32 oheimb Exp $
    Author:     Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1996  University of Cambridge
*)

Relation = Prod +
consts
    id          :: "('a * 'a)set"               (*the identity relation*)
    O           :: "[('b * 'c)set, ('a * 'b)set] => ('a * 'c)set" (infixr 60)
    inverse    :: "('a*'b) set => ('b*'a) set"     ("(_^-1)" [1000] 999)
    "^^"        :: "[('a*'b) set,'a set] => 'b set" (infixl 90)
    Domain      :: "('a*'b) set => 'a set"
    Range       :: "('a*'b) set => 'b set"
    trans       :: "('a * 'a)set => bool"       (*transitivity predicate*)
    Univalent   :: "('a * 'b)set => bool"
defs
    id_def        "id == {p. ? x. p = (x,x)}"
    comp_def      "r O s == {(x,z). ? y. (x,y):s & (y,z):r}"
    inverse_def   "r^-1 == {(y,x). (x,y):r}"
    Domain_def    "Domain(r) == {x. ? y. (x,y):r}"
    Range_def     "Range(r) == Domain(r^-1)"
    Image_def     "r ^^ s == {y. ? x:s. (x,y):r}"
    trans_def     "trans(r) == (!x y z. (x,y):r --> (y,z):r --> (x,z):r)"
    Univalent_def "Univalent r == !x y. (x,y):r --> (!z. (x,z):r --> y=z)"
end
