(*  Title:      HOL/ROOT.ML
    ID:         $Id: ROOT.ML,v 1.15 1996/10/21 07:50:52 nipkow Exp $
    Author:     Tobias Nipkow
    Copyright   1993  University of Cambridge

Adds Classical Higher-order Logic to a database containing Pure Isabelle.
Should be executed in the subdirectory HOL.
*)

val banner = "Higher-Order Logic with curried functions";
writeln banner;

print_depth 1;

(* Add user sections *)
use "../Pure/section_utils.ML";
use "thy_syntax.ML";

use "../Provers/splitter.ML";
use "../Provers/hypsubst.ML";
use "../Provers/classical.ML";
use "../Provers/nat_transitive.ML";


use_thy "HOL";
use_thy "Ord";
use_thy "subset";
use     "typedef.ML";
use_thy "Sum";
use_thy "Gfp";

use "datatype.ML";
use "ind_syntax.ML";
use "add_ind_def.ML";
use "intr_elim.ML";
use "indrule.ML";
use_thy "Inductive";

use_thy "RelPow";
use_thy "Finite";
use_thy "Sexp";
use_thy "Option";
use_thy "List";

init_pps ();
print_depth 8;

val HOL_build_completed = ();   (*indicate successful build*)
