(*  Title: 	HOL/simpdata.ML
    ID:         $Id: simpdata.ML,v 1.3 1993/09/28 13:27:31 lcp Exp $
    Author: 	Tobias Nipkow
    Copyright   1991  University of Cambridge

Instantiation of the generic simplifier
*)

open Simplifier;

local

fun prover s = prove_goal HOL.thy s (fn _ => [fast_tac HOL_cs 1]);

val P_imp_P_iff_True = prover "P --> (P = True)" RS mp;
val P_imp_P_eq_True = P_imp_P_iff_True RS eq_reflection;

val not_P_imp_P_iff_F = prover "~P --> (P = False)" RS mp;
val not_P_imp_P_eq_False = not_P_imp_P_iff_F RS eq_reflection;

fun atomize r =
  case concl_of r of
    Const("Trueprop",_) $ p =>
      (case p of
	 Const("op -->",_)$_$_ => atomize(r RS mp)
       | Const("op &",_)$_$_ => atomize(r RS conjunct1) @
	  		        atomize(r RS conjunct2)
       | Const("All",_)$_ => atomize(r RS spec)
       | Const("True",_) => []
       | Const("False",_) => []
       | _ => [r])
  | _ => [r];

fun mk_eq r = case concl_of r of
	Const("==",_)$_$_ => r
    |	_$(Const("op =",_)$_$_) => r RS eq_reflection
    |	_$(Const("not",_)$_) => r RS not_P_imp_P_eq_False
    |   _ => r RS P_imp_P_eq_True;
(* last 2 lines requires all formulae to be of the from Trueprop(.) *)

fun gen_all th = forall_elim_vars (#maxidx(rep_thm th)+1) th;

fun mk_rews thm = map mk_eq (atomize(gen_all thm));

val imp_cong = impI RSN
    (2, prove_goal HOL.thy "(P=P')--> (P'--> (Q=Q'))--> ((P-->Q) = (P'-->Q'))"
	(fn _=> [fast_tac HOL_cs 1]) RS mp RS mp);

val o_apply = prove_goal HOL.thy "(f o g)(x) = f(g(x))"
 (fn _ => [ (stac o_def 1), (rtac refl 1) ]);

val simp_thms = map prover
 [ "(x=x) = True",
   "(~True) = False", "(~False) = True", "(~ ~ P) = P",
   "(True=P) = P", "(P=True) = P",
   "(True --> P) = P", "(False --> P) = True", 
   "(P --> True) = True", "(P --> P) = True",
   "(P & True) = P", "(True & P) = P", 
   "(P & False) = False", "(False & P) = False", "(P & P) = P",
   "(P | True) = True", "(True | P) = True", 
   "(P | False) = P", "(False | P) = P", "(P | P) = P",
   "(!x.P) = P",
   "(P|Q --> R) = ((P-->R)&(Q-->R))" ];

val meta_obj_reflection = prove_goal HOL.thy "x==y ==> x=y"
  (fn [prem] => [rewtac prem, rtac refl 1]);

in


val if_True = prove_goal HOL.thy "if(True,x,y) = x"
 (fn _=>[stac if_def 1,  fast_tac (HOL_cs addIs [select_equality]) 1]);

val if_False = prove_goal HOL.thy "if(False,x,y) = y"
 (fn _=>[stac if_def 1,  fast_tac (HOL_cs addIs [select_equality]) 1]);

val if_P = prove_goal HOL.thy "P ==> if(P,x,y) = x"
 (fn [prem] => [ stac (prem RS eqTrueI) 1, rtac if_True 1 ]);

val if_not_P = prove_goal HOL.thy "~P ==> if(P,x,y) = y"
 (fn [prem] => [ stac (prem RS not_P_imp_P_iff_F) 1, rtac if_False 1 ]);

val expand_if = prove_goal HOL.thy
    "P(if(Q,x,y)) = ((Q --> P(x)) & (~Q --> P(y)))"
 (fn _=> [ (res_inst_tac [("Q","Q")] (excluded_middle RS disjE) 1),
	 rtac (if_P RS ssubst) 2,
	 rtac (if_not_P RS ssubst) 1,
	 REPEAT(fast_tac HOL_cs 1) ]);

infix addcongs;
fun ss addcongs congs = ss addeqcongs (congs RL [eq_reflection]);

val HOL_ss = empty_ss
      setmksimps mk_rews
      setsolver (fn prems => resolve_tac (TrueI::refl::prems))
      setsubgoaler asm_simp_tac
      addsimps ([if_True, if_False, o_apply] @ simp_thms)
      addcongs [imp_cong];

fun split_tac splits =
  mk_case_split_tac (meta_obj_reflection RS iffD2) (map mk_eq splits);

(** 'if' congruence rules: neither included by default! *)

(*Simplifies x assuming c and y assuming ~c*)
val if_cong = prove_goal HOL.thy
  "[| b=c; c ==> x=u; ~c ==> y=v |] ==> if(b,x,y) = if(c,u,v)"
  (fn rew::prems =>
   [stac rew 1, stac expand_if 1, stac expand_if 1,
    fast_tac (HOL_cs addDs prems) 1]);

(*Prevents simplification of x and y: much faster*)
val if_weak_cong = prove_goal HOL.thy
  "b=c ==> if(b,x,y) = if(c,x,y)"
  (fn [prem] => [rtac (prem RS arg_cong) 1]);

end;
