(*  Title:      theory-template
    Author:     Tobias Nipkow and Lawrence C Paulson

Template file for defining new theories
*)

(**** Template for theories that do not extend the syntax ****)

val xxx_thy = extend_theory parent_thy "xxx" 
   ([],			(* new classes *)
    [],			(* default sort *)
    [],			(* old types *)
    [],			(* new types *)
    [],			(* constants *)
    None)
[
  (* new axioms/rules go here *)
];

local val ax = get_axiom xxx_thy
in
  (* ML bindings for axiom names -- generated automatically by get-rulenames *)
end;


(**** Template for theories that do extend the syntax ****)

local
val mixfix =
  [ (* new mixfix declarations *) ];

val sext = Sext{mixfix=mixfix, parse_translation=[], print_translation=[]};
in

val xxx_thy = extend_theory parent_thy "xxx" 
   ([],			(* new classes *)
    [],			(* default sort *)
    [],			(* old types *)
    [],			(* new types *)
    [],			(* constants *)
    Some sext)		(* new syntax *)
[
  (* new axioms/rules go here *)
];

local val ax = get_axiom xxx_thy
in
  (* ML bindings for axiom names -- generated automatically by get-rulenames *)
end
end;
