; prove_goal.el
;
; Emacs command to change "goal" proofs to "prove_goal" proofs 
;    [would be difficult in "sed" since replacements involve multiple lines]
; 
; val PAT = goalARGS;$
; COMMANDS;$
; val ID = result();
; 
; to
; 
; val ID = prove_goalARGS
;  (fn PAT=>
; COMMANDS ]);

(defun prove-goalify ()
  "Change well-formed goal...result proofs to use prove_goal"
  (interactive "*")        ; fail if buffer is read-only

  ; 1: delimit the identifier in "val ID = result()" using ^Q
  (goto-char (point-min))
  (replace-regexp  "val \\([^ ]*\\)  *= *result(); *$"  "\\1")

  ; 2: replace terminal ";  by  
  (goto-char (point-min))
  (replace-regexp  "\"; *$"  "")

  ; 3: replace lines "by ...;" with "...,"
  (goto-char (point-min))
  (replace-regexp  "by *\\([^;]*\\);"  "    \\1,")

  ; 4: removing the extra commas, those followed by ^Q
  (goto-char (point-min))
  (replace-string  ",
"  "")

  ; 5: transforming goal... to prove_goal...
  (goto-char (point-min))
  (replace-regexp  "val \\([^ =;]*\\) = goal\\([^]*\\)
\\([^]*\\)\\([^]*\\)"  "val \\4 = prove_goal\\2\"
 (fn \\1=>
  [ \\3 ]);")

  ; 5': transforming goal... to prove_goal... (with no prems binding)
  (goto-char (point-min))
  (replace-regexp  "^goal\\([^]*\\)
\\([^]*\\)\\([^]*\\)"  "val \\3 = prove_goal\\1\"
 (fn _ =>
  [ \\2 ]);")

  ; 6: removing excess spaces
  (goto-char (point-min))
  (replace-string  "[     ("  "[ (" )
)
