(*  Title: 	ZF/sum
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

Disjoint sums in Zermelo-Fraenkel Set Theory 
*)

structure Sum =
struct
val mixfix = 
    [ Infixr("+","[i,i]=>i",65) ];

val sext = Sext{mixfix			= mixfix,
                parse_translation	= [],
                print_translation	= []};

val const_decs =
    [ (["Inl","Inr"],	"i=>i"),
      (["case"],	"[i,i=>i,i=>i]=>i") ];

val thy = extend_theory ZF_Rule.thy "sum"
     ([], [], [], [], const_decs, Some sext)
  [ 
    ("sum_def",		"A+B == {0}*A Un {{0}}*B"),
    ("Inl_def",		"Inl(a) == < 0 ,a>"),
    ("Inr_def",		"Inr(b) == <{0},b>"),
    ("case_def",	
     "case(u,c,d) == THE y. EX z.(u=Inl(z) & y=c(z)) | (u=Inr(z) & y=d(z))")
  ];
end;

local val ax = get_axiom Sum.thy
in 
val sum_def 	= ax"sum_def";
val Inl_def	= ax"Inl_def";
val Inr_def	= ax"Inr_def";
val case_def 	= ax"case_def";
end;

val sum_defs = [sum_def,Inl_def,Inr_def,case_def];


(* constructors *)

val prems = goalw Sum.thy sum_defs "a : A ==> Inl(a) : A+B";
by (REPEAT (resolve_tac (prems @ [UnI1,SigmaI,singletonI]) 1));
val sum_InlI = result();

val prems = goalw Sum.thy sum_defs "b : B ==> Inr(b) : A+B";
by (REPEAT (resolve_tac (prems @ [UnI2,SigmaI,singletonI]) 1));
val sum_InrI = result();

(* Injection rules *)

val [major] = goalw Sum.thy sum_defs "Inl(a)=Inl(b) ==> a=b";
by (EVERY1 [rtac (major RS Pair_inject), atac]);
val Inl_inject = result();

val [major] = goalw Sum.thy sum_defs "Inr(a)=Inr(b) ==> a=b";
by (EVERY1 [rtac (major RS Pair_inject), atac]);
val Inr_inject = result();

val [major] = goalw Sum.thy sum_defs "Inl(a)=Inr(b) ==> P";
by (rtac (major RS Pair_inject) 1);
by (etac (equalityD2 RS subsetD RS emptyE) 1);
by (rtac consI1 1);
val Inl_neq_Inr = result();

val prems = goalw Sum.thy sum_defs
    "[| u: A+B;  \
\       !!x. x:A ==> P(Inl(x)); \
\       !!y. y:B ==> P(Inr(y)) \
\    |] ==> P(u)";
by (cut_facts_tac prems 1);
by (REPEAT (eresolve_tac [UnE,SigmaE,singletonE,ssubst] 1
     ORELSE ares_tac prems 1));
val sumE = result();

val [major] = goal Sum.thy
    "u: A+B ==> (EX x. x:A & u=Inl(x)) | (EX y. y:B & u=Inr(y))";
by (rtac (major RS sumE) 1);
by (fast_tac ZF_cs 1);
by (fast_tac ZF_cs 1);
val sumE2 = result();


(*** Eliminator -- case ***)

goalw Sum.thy [case_def] "case(Inl(a),c,d) = c(a)";
by (fast_tac (ZF_cs addIs [the_equality] 
		    addEs [make_elim Inl_inject, Inl_neq_Inr]) 1);
val case_Inl_conv = result();

goalw Sum.thy [case_def] "case(Inr(b),c,d) = d(b)";
by (fast_tac (ZF_cs addIs [the_equality] 
		    addEs [make_elim Inr_inject, sym RS Inl_neq_Inr]) 1);
val case_Inr_conv = result();

val major::prems = goal Sum.thy
    "[| u: A+B; \
\       !!x. x: A ==> c(x): C(Inl(x));   \
\       !!y. y: B ==> d(y): C(Inr(y)) \
\    |] ==> case(u,c,d) : C(u)";
by (rtac (major RS sumE) 1);
by (REPEAT (resolve_tac [case_Inl_conv RS ssubst, case_Inr_conv RS ssubst] 1
       THEN eresolve_tac prems 1));
val case_type = result();


val symtrans = sym RSN (2, trans RS sym);
val caseths =   ([case_Inl_conv,case_Inr_conv] RL [trans])
              @ ([case_Inl_conv,case_Inr_conv] RL [symtrans]);

val prems = goalw Sum.thy [case_def]
    "[| u=u'; !!x. c(x)=c'(x);  !!y. d(y)=d'(y)    \
\    |] ==> case(u,c,d)=case(u',c',d')";
by (rtac the_cong 1);
by (rtac ex_cong 1);
by (EVERY1 (map rtac ((prems RL [ssubst]) @ [iff_refl])));
val case_cong = result();

val prems = goal Sum.thy
    "[| u: A+B; \
\       u=u'; \
\       !!x. x: A ==> c(x)=c'(x);   \
\       !!y. y: B ==> d(y)=d'(y)    \
\    |] ==> case(u,c,d)=case(u',c',d')";
by (cut_facts_tac prems 1);
by (etac subst 1);
by (etac sumE 1);
by (REPEAT (ares_tac (prems@caseths) 1));
val case_cong_typed = result();

val prems = goalw Sum.thy sum_defs "[| A<=C;  B<=D |] ==> A+B <= C+D";
by (REPEAT (resolve_tac (prems@[subset_refl,Un_mono,product_mono]) 1));
val sum_mono = result();
