(*  Title: 	ZF/subset
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Derived rules involving subsets
Union and Intersection as lattice operations
*)

(*** cons ***)

val cons_subsetI = prove_goal ZF_Rule.thy "[| a:C; B<=C |] ==> cons(a,B) <= C"
 (fn prems=>
  [ (cut_facts_tac prems 1),
    (REPEAT (ares_tac [subsetI] 1
     ORELSE eresolve_tac  [consE,ssubst,subsetD] 1)) ]);

(*A special case of subset elimination, adding no new variables *)
val cons_subsetE = prove_goal ZF_Rule.thy
    "[| cons(a,B) <= C;  [| a:C;  B<=C |] ==> P \
\    |] ==> P"
 (fn prems=>
  [ (cut_facts_tac prems 1),
    (resolve_tac prems 1),
    (REPEAT (ares_tac [subsetI,consI1,consI2] 1
     ORELSE etac subsetD 1)) ]);

(*** succ ***)

val succ_subsetI = prove_goalw ZF_Rule.thy [succ_def]
    "[| i:j;  i<=j |] ==> succ(i)<=j"
 (fn prems=>
  [ (REPEAT (ares_tac (prems@[cons_subsetI]) 1)) ]);

val succ_subsetE = prove_goalw ZF_Rule.thy [succ_def] 
    "[| succ(i) <= j;  [| i:j;  i<=j |] ==> P \
\    |] ==> P"
 (fn major::prems=>
  [ (rtac (major RS cons_subsetE) 1),
    (REPEAT (ares_tac prems 1)) ]);

(*** singletons ***)

val singleton_subsetI = prove_goal ZF_Rule.thy
    "a:C ==> {a} <= C"
 (fn prems=>
  [ (REPEAT (resolve_tac (prems@[cons_subsetI,empty_subsetI]) 1)) ]);

val singleton_subsetD = prove_goal ZF_Rule.thy
    "{a} <= C  ==>  a:C"
 (fn prems=> [ (REPEAT (ares_tac (prems@[cons_subsetE]) 1)) ]);

(*** Big Union -- least upper bound of a set  ***)

val Union_upper = prove_goal ZF_Rule.thy
    "B:A ==> B <= Union(A)"
 (fn prems=> [ (REPEAT (ares_tac (prems@[subsetI,UnionI]) 1)) ]);

val Union_least = prove_goal ZF_Rule.thy
    "[| !!x. x:A ==> x<=C |] ==> Union(A) <= C"
 (fn prems=>
  [ (REPEAT (ares_tac [subsetI] 1
     ORELSE eresolve_tac ([UnionE]@(prems RL [subsetD])) 1)) ]);

val UN_least = prove_goal ZF_Rule.thy
    "[| !!x. x:A ==> f(x)<=C |] ==> Union(RepFun(A,f)) <= C"
 (fn prems=>
  [ (REPEAT (ares_tac [subsetI] 1
     ORELSE eresolve_tac ([UN_E]@(prems RL [subsetD])) 1)) ]);


(*** Big Intersection -- greatest lower bound of a nonempty set ***)

val Inter_lower = prove_goal ZF_Rule.thy "B:A ==> Inter(A) <= B"
 (fn prems=>
  [ (REPEAT (resolve_tac (prems@[subsetI]) 1
     ORELSE etac InterD 1)) ]);

val Inter_greatest = prove_goal ZF_Rule.thy
    "[| a:A;  !!x. x:A ==> C<=x |] ==> C <= Inter(A)"
 (fn prems=>
  [ (cut_facts_tac prems 1),
    (REPEAT (ares_tac [subsetI,InterI] 1
     ORELSE eresolve_tac (prems RL [subsetD]) 1)) ]);

(*** Finite Union -- the least upper bound of 2 sets ***)

val Un_upper1 = prove_goal ZF_Rule.thy "A <= A Un B"
 (fn _ => [ (REPEAT (ares_tac [subsetI,UnI1] 1)) ]);

val Un_upper2 = prove_goal ZF_Rule.thy "B <= A Un B"
 (fn _ => [ (REPEAT (ares_tac [subsetI,UnI2] 1)) ]);

val Un_least = prove_goal ZF_Rule.thy "[| A<=C;  B<=C |] ==> A Un B <= C"
 (fn prems=>
  [ (cut_facts_tac prems 1),
    (DEPTH_SOLVE (ares_tac [subsetI] 1 
          ORELSE eresolve_tac [UnE,subsetD] 1)) ]);

(*** Finite Intersection -- the greatest lower bound of 2 sets *)

val Int_lower1 = prove_goal ZF_Rule.thy "A Int B <= A"
 (fn _ => [ (REPEAT (ares_tac [subsetI] 1 ORELSE etac IntE 1)) ]);

val Int_lower2 = prove_goal ZF_Rule.thy "A Int B <= B"
 (fn _ => [ (REPEAT (ares_tac [subsetI] 1 ORELSE etac IntE 1)) ]);

val Int_greatest = prove_goal ZF_Rule.thy "[| C<=A;  C<=B |] ==> C <= A Int B"
 (fn prems=>
  [ (cut_facts_tac prems 1),
    (REPEAT (ares_tac [subsetI,IntI] 1
     ORELSE etac subsetD 1)) ]);

(*** Set difference *)

val Diff_subset = prove_goal ZF_Rule.thy "A-B <= A"
 (fn _ => [ (REPEAT (ares_tac [subsetI] 1 ORELSE etac DiffE 1)) ]);

val Diff_contains = prove_goal ZF_Rule.thy
    "[| C<=A;  C Int B = 0 |] ==> C <= A-B"
 (fn prems=>
  [ (cut_facts_tac prems 1),
    (rtac subsetI 1),
    (REPEAT (ares_tac [DiffI,IntI,notI] 1
     ORELSE eresolve_tac [subsetD,equals0D] 1)) ]);

(** Collect **)

val Collect_subset = prove_goal ZF_Rule.thy "Collect(A,P) <= A"
 (fn _ => [ (REPEAT (ares_tac [subsetI] 1 ORELSE etac CollectD1 1)) ]);

(** RepFun **)

val prems = goal ZF_Rule.thy "[| !!x. x:A ==> f(x): B |] ==> RepFun(A,f) <= B";
by (rtac subsetI 1);
by (etac RepFunE 1);
by (etac ssubst 1);
by (eresolve_tac prems 1);
val RepFun_subset = result();
