(*  Title: 	ZF/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Adds Zermelo-Fraenkel Set Theory to a database containing First-Order Logic.

This theory is the work of Martin Coen, Philippe Noel and Lawrence Paulson.
*)

writeln"Root file for ZF Set Theory";

print_depth 1;
use "syntax.ML";
use ".rules.ML";
use "lemmas.ML";

print_depth 1;  
structure ZF_Syntax =  ZF_SyntaxFun();
structure ZF_Rule = ZF_RuleFun(ZF_Syntax);
structure ZF_Lemmas = ZF_LemmasFun(ZF_Rule);

open ZF_Rule ZF_Lemmas;

use "upair.ML";
use "subset.ML";
use "pair.ML";
use "domrange.ML";
use "func.ML";
use "simpdata.ML";  

(*further development*)
use "mono.ML";
use "equalities.ML";
use "sum.ML";
use "perm.ML";
use "fixedpt.ML";
use "trancl.ML";
use "wf.ML";
use "ordinal.ML";
use "nat.ML";
use "epsilon.ML";
use "univ.ML";

val ZF_thy = Univ.thy;  (*should denote the full theory*)

(* Set up automatic printing -- works in Poly/ML only *)
install_pp (K print_thm);   				(*theorems*)
install_pp (K prin);        				(*terms*)
install_pp (K (writeln o Sign.string_of_cterm));	(*cterms*)
print_depth 8;
