(*  Title: 	FOL/ex/list
    Author: 	Tobias Nipkow
    Copyright   1991  University of Cambridge

Examples of simplification and induction on lists
*)

local 

  val mixfix =
  [Delimfix("[]", "'a list", "[]"),
   Infixr(".", "['a, 'a list] => 'a list", 80),
   Infixr("++", "['a list, 'a list] => 'a list", 70)
  ];

  val sext = Sext{mixfix=mixfix, parse_translation=[], print_translation=[]};

  val const_decs =
   [(["hd"], 	"'a list => 'a"),
    (["tl"], 	"'a list => 'a list"),
    (["forall"], "['a list, 'a => o] => o"),
    (["len"], "'a list => nat"),
    (["at"], "['a list, nat] => 'a")
   ];

in

val list_thy = extend_theory nat_thy "List"
    ([], [], [],
     [(["list"], ([["term"]],"term"))], 
     const_decs, Some(sext))
[
 ("list_ind", "[| P([]);  ALL x l. P(l)-->P(x.l) |] ==> All(P)"),

 ("forall_cong", 
  "[| l = l';  !!x. P(x)<->P'(x) |] ==> forall(l,P) <-> forall(l',P')"),

 ("list_distinct1", "~[] = x.l"),
 ("list_distinct2", "~x.l = []"),

 ("list_free", 	"x.l = x'.l' <-> x=x' & l=l'"),

 ("app_nil", 	"[]++l = l"),
 ("app_cons", 	"(x.l)++l' = x.(l++l')"),
 ("tl_eq", 	"tl(m.q) = q"),
 ("hd_eq", 	"hd(m.q) = m"),

 ("forall_nil", "forall([],P)"),
 ("forall_cons", "forall(x.l,P) <-> P(x) & forall(l,P)"),

 ("len_nil", "len([]) = 0"),
 ("len_cons", "len(m.q) = succ(len(q))"),

 ("at_0", "at(m.q,0) = m"),
 ("at_succ", "at(m.q,succ(n)) = at(q,n)")

];

end;

local val ax = get_axiom list_thy
in
val list_ind = ax"list_ind";
val forall_cong = ax"forall_cong";
val list_distinct1 = ax"list_distinct1";
val list_distinct2 = ax"list_distinct2";
val list_free = ax"list_free";
val app_nil = ax"app_nil";
val app_cons = ax"app_cons";
val tl_eq = ax"tl_eq";
val hd_eq = ax"hd_eq";
val forall_nil = ax"forall_nil";
val forall_cons = ax"forall_cons";
val len_nil = ax"len_nil";
val len_cons = ax"len_cons";
val at_0 = ax"at_0";
val at_succ = ax"at_succ";
end;


val prems = goal list_thy 
    "[| P([]);  !!x l. P(x.l) |] ==> All(P)";
by (rtac list_ind 1);
by (REPEAT (resolve_tac (prems@[allI,impI]) 1));
val list_exh = result();

val list_cong_thms = forall_cong :: 
          mk_congs list_thy ["hd","tl","op .","op ++", "len", "at"];

val list_rew_thms = [list_distinct1,list_distinct2,app_nil,app_cons,
		     hd_eq,tl_eq,forall_nil,forall_cons,list_free,
		     len_nil,len_cons,at_0,at_succ];

val list_ss = nat_ss addcongs list_cong_thms addrews list_rew_thms;

goal list_thy "~l=[] --> hd(l).tl(l) = l";
by(IND_TAC list_exh (SIMP_TAC list_ss) "l" 1);
result();

goal list_thy "(l1++l2)++l3 = l1++(l2++l3)";
by(IND_TAC list_ind (SIMP_TAC list_ss) "l1" 1);
val append_assoc = result();

goal list_thy "l++[] = l";
by(IND_TAC list_ind (SIMP_TAC list_ss) "l" 1);
val app_nil_right = result();

goal list_thy "l1++l2=[] <-> l1=[] & l2=[]";
by(IND_TAC list_exh (SIMP_TAC list_ss) "l1" 1);
val app_eq_nil_iff = result();

goal list_thy "forall(l++l',P) <-> forall(l,P) & forall(l',P)";
by(IND_TAC list_ind (SIMP_TAC list_ss) "l" 1);
val forall_app = result();

goal list_thy "forall(l,%x.P(x)&Q(x)) <-> forall(l,P) & forall(l,Q)";
by(IND_TAC list_ind (SIMP_TAC list_ss) "l" 1);
by(fast_tac FOL_cs 1);
val forall_conj = result();

goal list_thy "~l=[] --> forall(l,P) <-> P(hd(l)) & forall(tl(l),P)";
by(IND_TAC list_ind (SIMP_TAC list_ss) "l" 1);
val forall_ne = result();

(*** Lists with natural numbers ***)

goal list_thy "len(l1++l2) = len(l1)+len(l2)";
by (IND_TAC list_ind (SIMP_TAC list_ss) "l1" 1);
val len_app = result();

goal list_thy "i<len(l1) --> at(l1++l2,i) = at(l1,i)";
by (IND_TAC list_ind (SIMP_TAC list_ss) "l1" 1);
by (REPEAT (rtac allI 1));
by (rtac impI 1);
by (ALL_IND_TAC nat_exh (ASM_SIMP_TAC list_ss) 1);
val at_app1 = result();

goal list_thy "at(l1++(x.l2), len(l1)) = x";
by (IND_TAC list_ind (SIMP_TAC list_ss) "l1" 1);
val at_app_hd2 = result();

