(*  Title: 	FOL/ex/cla
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

Classical First-Order Logic
*)

writeln"File FOL/ex/cla.";

open Cla;    (*in case structure Int is open!*)

goal cla_thy "(P --> Q | R) --> (P-->Q) | (P-->R)";
by (fast_tac FOL_cs 1);
result();

(*If and only if*)

goal cla_thy "(P<->Q) <-> (Q<->P)";
by (fast_tac FOL_cs 1);
result();

goal cla_thy "~ (P <-> ~P)";
by (fast_tac FOL_cs 1);
result();


(*Sample problems from 
  F. J. Pelletier, 
  Seventy-Five Problems for Testing Automatic Theorem Provers,
  J. Automated Reasoning 2 (1986), 191-216.
  Errata, JAR 4 (1988), 236-236.

The hardest problems -- judging by experience with several theorem provers,
including matrix ones -- are 34 and 43.
*)

writeln"Pelletier's examples";
(*1*)
goal cla_thy "(P-->Q)  <->  (~Q --> ~P)";
by (fast_tac FOL_cs 1);
result();

(*2*)
goal cla_thy "~ ~ P  <->  P";
by (fast_tac FOL_cs 1);
result();

(*3*)
goal cla_thy "~(P-->Q) --> (Q-->P)";
by (fast_tac FOL_cs 1);
result();

(*4*)
goal cla_thy "(~P-->Q)  <->  (~Q --> P)";
by (fast_tac FOL_cs 1);
result();

(*5*)
goal cla_thy "((P|Q)-->(P|R)) --> (P|(Q-->R))";
by (fast_tac FOL_cs 1);
result();

(*6*)
goal cla_thy "P | ~ P";
by (fast_tac FOL_cs 1);
result();

(*7*)
goal cla_thy "P | ~ ~ ~ P";
by (fast_tac FOL_cs 1);
result();

(*8.  Peirce's law*)
goal cla_thy "((P-->Q) --> P)  -->  P";
by (fast_tac FOL_cs 1);
result();

(*9*)
goal cla_thy "((P|Q) & (~P|Q) & (P| ~Q)) --> ~ (~P | ~Q)";
by (fast_tac FOL_cs 1);
result();

(*10*)
goal cla_thy "(Q-->R) & (R-->P&Q) & (P-->Q|R) --> (P<->Q)";
by (fast_tac FOL_cs 1);
result();

(*11.  Proved in each direction (incorrectly, says Pelletier!!)  *)
goal cla_thy "P<->P";
by (fast_tac FOL_cs 1);
result();

(*12.  "Dijkstra's law"*)
goal cla_thy "((P <-> Q) <-> R)  <->  (P <-> (Q <-> R))";
by (fast_tac FOL_cs 1);
result();

(*13.  Distributive law*)
goal cla_thy "P | (Q & R)  <-> (P | Q) & (P | R)";
by (fast_tac FOL_cs 1);
result();

(*14*)
goal cla_thy "(P <-> Q) <-> ((Q | ~P) & (~Q|P))";
by (fast_tac FOL_cs 1);
result();

(*15*)
goal cla_thy "(P --> Q) <-> (~P | Q)";
by (fast_tac FOL_cs 1);
result();

(*16*)
goal cla_thy "(P-->Q) | (Q-->P)";
by (fast_tac FOL_cs 1);
result();

(*17*)
goal cla_thy "((P & (Q-->R))-->S) <-> ((~P | Q | S) & (~P | ~R | S))";
by (fast_tac FOL_cs 1);
result();

writeln"Classical Logic: examples with quantifiers";

goal cla_thy "(ALL x. P(x) & Q(x)) <-> (ALL x. P(x))  &  (ALL x. Q(x))";
by (fast_tac FOL_cs 1);
result(); 

goal cla_thy "(EX x. P-->Q(x))  <->  (P --> (EX x.Q(x)))";
by (fast_tac FOL_cs 1);
result(); 

goal cla_thy "(EX x.P(x)-->Q)  <->  (ALL x.P(x)) --> Q";
by (fast_tac FOL_cs 1);
result(); 

goal cla_thy "(ALL x.P(x)) | Q  <->  (ALL x. P(x) | Q)";
by (fast_tac FOL_cs 1);
result(); 

writeln"Problems requiring quantifier duplication";

(*Needs multiple instantiation of ALL.*)
goal cla_thy "(ALL x. P(x)-->P(f(x)))  &  P(d)-->P(f(f(f(d))))";
by (best_tac FOL_dup_cs 1);
result();

(*Needs double instantiation of the quantifier*)
goal cla_thy "EX x. P(x) --> P(a) & P(b)";
by (best_tac FOL_dup_cs 1);
result();

goal cla_thy "EX z. P(z) --> (ALL x. P(x))";
by (best_tac FOL_dup_cs 1);
result();

(*from Vladimir Lifschitz, What Is the Inverse Method?, JAR 5 (1989), 1--23*)
goal cla_thy "EX x X. ALL y. EX z Z. \
\               (~P(y,y) | P(x,x) | ~S(z,x)) & \
\               (S(x,y) | ~S(y,z) | Q(Z,Z))  & \
\               (Q(X,y) | ~Q(y,Z) | S(X,X))";

writeln"Hard examples with quantifiers";

writeln"Problem 18";
goal cla_thy "EX y. ALL x. P(y)-->P(x)";
by (best_tac FOL_dup_cs 1);
result(); 

writeln"Problem 19";
goal cla_thy "EX x. ALL y z. (P(y)-->Q(z)) --> (P(x)-->Q(x))";
by (best_tac FOL_dup_cs 1);
result();

writeln"Problem 20";
goal cla_thy "(ALL x y. EX z. ALL w. (P(x)&Q(y)-->R(z)&S(w)))     \
\   --> (EX x y. P(x) & Q(y)) --> (EX z. R(z))";
by (fast_tac FOL_cs 1); 
result();

writeln"Problem 21";
goal cla_thy "(EX x. P-->Q(x)) & (EX x. Q(x)-->P) --> (EX x. P<->Q(x))";
by (best_tac FOL_dup_cs 1);
result();

writeln"Problem 22";
goal cla_thy "(ALL x. P <-> Q(x))  -->  (P <-> (ALL x. Q(x)))";
by (fast_tac FOL_cs 1); 
result();

writeln"Problem 23";
goal cla_thy "(ALL x. P | Q(x))  <->  (P | (ALL x. Q(x)))";
by (best_tac FOL_cs 1);  
result();

writeln"Problem 24";
goal cla_thy "~(EX x. S(x)&Q(x)) & (ALL x. P(x) --> Q(x)|R(x)) &  \
\    ~(EX x.P(x)) --> (EX x.Q(x)) & (ALL x. Q(x)|R(x) --> S(x))  \
\   --> (EX x. P(x)&R(x))";
by (fast_tac FOL_cs 1); 
result();

writeln"Problem 25";
goal cla_thy "(EX x. P(x)) &  \
\       (ALL x. L(x) --> ~ (M(x) & R(x))) &  \
\       (ALL x. P(x) --> (M(x) & L(x))) &   \
\       ((ALL x. P(x)-->Q(x)) | (EX x. P(x)&R(x)))  \
\   --> (EX x. Q(x)&P(x))";
by (best_tac FOL_cs 1); 
result();

writeln"Problem 26";
goal cla_thy "((EX x. p(x)) <-> (EX x. q(x))) &	\
\     (ALL x. ALL y. p(x) & q(y) --> (r(x) <-> s(y)))	\
\ --> ((ALL x. p(x)-->r(x)) <-> (ALL x. q(x)-->s(x)))";
by (fast_tac FOL_cs 1);
result();

writeln"Problem 27";
goal cla_thy "(EX x. P(x) & ~Q(x)) &   \
\             (ALL x. P(x) --> R(x)) &   \
\             (ALL x. M(x) & L(x) --> P(x)) &   \
\             ((EX x. R(x) & ~ Q(x)) --> (ALL x. L(x) --> ~ R(x)))  \
\         --> (ALL x. M(x) --> ~L(x))";
by (fast_tac FOL_cs 1); 
result();

writeln"Problem 28.  AMENDED";
goal cla_thy "(ALL x. P(x) --> (ALL x. Q(x))) &   \
\       ((ALL x. Q(x)|R(x)) --> (EX x. Q(x)&S(x))) &  \
\       ((EX x.S(x)) --> (ALL x. L(x) --> M(x)))  \
\   --> (ALL x. P(x) & L(x) --> M(x))";
by (fast_tac FOL_cs 1);  
result();

writeln"Problem 29.  Essentially the same as Principia Mathematica *11.71";
goal cla_thy "(EX x. P(x)) & (EX y. Q(y))  \
\   --> ((ALL x. P(x)-->R(x)) & (ALL y. Q(y)-->S(y))   <->     \
\        (ALL x y. P(x) & Q(y) --> R(x) & S(y)))";
by (fast_tac FOL_cs 1); 
result();

writeln"Problem 30";
goal cla_thy "(ALL x. P(x) | Q(x) --> ~ R(x)) & \
\       (ALL x. (Q(x) --> ~ S(x)) --> P(x) & R(x))  \
\   --> (ALL x. S(x))";
by (fast_tac FOL_cs 1);  
result();

writeln"Problem 31";
goal cla_thy "~(EX x.P(x) & (Q(x) | R(x))) & \
\       (EX x. L(x) & P(x)) & \
\       (ALL x. ~ R(x) --> M(x))  \
\   --> (EX x. L(x) & M(x))";
by (fast_tac FOL_cs 1);
result();

writeln"Problem 32";
goal cla_thy "(ALL x. P(x) & (Q(x)|R(x))-->S(x)) & \
\       (ALL x. S(x) & R(x) --> L(x)) & \
\       (ALL x. M(x) --> R(x))  \
\   --> (ALL x. P(x) & M(x) --> L(x))";
by (best_tac FOL_cs 1);
result();

writeln"Problem 33";
goal cla_thy "(ALL x. P(a) & (P(x)-->P(b))-->P(c))  <->    \
\    (ALL x. (~P(a) | P(x) | P(c)) & (~P(a) | ~P(b) | P(c)))";
by (best_tac FOL_cs 1);
result();

writeln"Problem 34  AMENDED (TWICE!!)  NOT PROVED AUTOMATICALLY";
(*Andrews's challenge*)
goal cla_thy "((EX x. ALL y. p(x) <-> p(y))  <->		\
\              ((EX x. q(x)) <-> (ALL y. p(y))))     <->	\
\             ((EX x. ALL y. q(x) <-> q(y))  <->		\
\              ((EX x. p(x)) <-> (ALL y. q(y))))";
by (safe_tac FOL_cs);			(*22 secs*)
by (TRYALL (fast_tac FOL_cs));		(*128 secs*)
by (TRYALL (best_tac FOL_dup_cs));	(*77 secs*)
result();

writeln"Problem 35";
goal cla_thy "EX x y. P(x,y) -->  (ALL u v. P(u,v))";
by (best_tac FOL_dup_cs 1);
result();

writeln"Problem 36";
goal cla_thy
     "(ALL x. EX y. J(x,y)) & \
\     (ALL x. EX y. G(x,y)) & \
\     (ALL x y. J(x,y) | G(x,y) --> (ALL z. J(y,z) | G(y,z) --> H(x,z)))   \
\ --> (ALL x. EX y. H(x,y))";
by (fast_tac FOL_cs 1);
result();

writeln"Problem 37";
goal cla_thy "(ALL z. EX w. ALL x. EX y. \
\          (P(x,z)-->P(y,w)) & P(y,z) & (P(y,w) --> (EX u.Q(u,w)))) & \
\       (ALL x z. ~P(x,z) --> (EX y. Q(y,z))) & \
\       ((EX x y. Q(x,y)) --> (ALL x. R(x,x)))  \
\   --> (ALL x. EX y. R(x,y))";
by (fast_tac FOL_cs 1);
result();

writeln"Problem 38. NOT PROVED";
goal cla_thy
    "(ALL x. p(a) & (p(x) --> (EX y. p(y) & r(x,y))) -->	\
\            (EX z. EX w. p(z) & r(x,w) & r(w,z)))  <->		\
\    (ALL x. (~p(a) | p(x) | (EX z. EX w. p(z) & r(x,w) & r(w,z))) &	\
\            (~p(a) | ~(EX y. p(y) & r(x,y)) |				\
\             (EX z. EX w. p(z) & r(x,w) & r(w,z))))";

writeln"Problem 39";
goal cla_thy "~ (EX x. ALL y. F(y,x) <-> ~F(y,y))";
by (fast_tac FOL_cs 1);
result();

writeln"Problem 40.  AMENDED";
goal cla_thy "(EX y. ALL x. F(x,y) <-> F(x,x)) -->  \
\             ~(ALL x. EX y. ALL z. F(z,y) <-> ~ F(z,x))";
by (fast_tac FOL_cs 1);
result();

writeln"Problem 41";
goal cla_thy "(ALL z. EX y. ALL x. f(x,y) <-> f(x,z) & ~ f(x,x))	\
\         --> ~ (EX z. ALL x. f(x,z))";
by (best_tac FOL_cs 1);
result();

writeln"Problem 42  NOT PROVED";
goal cla_thy "~ (EX y. ALL x. p(x,y) <-> ~ (EX z. p(x,z) & p(z,x)))";

writeln"Problem 43  NOT PROVED AUTOMATICALLY";
goal cla_thy "(ALL x. ALL y. q(x,y) <-> (ALL z. p(z,x) <-> p(z,y)))	\
\         --> (ALL x. (ALL y. q(x,y) <-> q(y,x)))";


writeln"Problem 44";
goal cla_thy "(ALL x. f(x) -->						\
\             (EX y. g(y) & h(x,y) & (EX y. g(y) & ~ h(x,y))))  &   	\
\             (EX x. j(x) & (ALL y. g(y) --> h(x,y)))			\
\             --> (EX x. j(x) & ~f(x))";
by (fast_tac FOL_cs 1);
result();

writeln"Problem 45";
goal cla_thy "(ALL x. f(x) & (ALL y. g(y) & h(x,y) --> j(x,y))	\
\                     --> (ALL y. g(y) & h(x,y) --> k(y))) &	\
\     ~ (EX y. l(y) & k(y)) &					\
\     (EX x. f(x) & (ALL y. h(x,y) --> l(y))			\
\                  & (ALL y. g(y) & h(x,y) --> j(x,y)))		\
\     --> (EX x. f(x) & ~ (EX y. g(y) & h(x,y)))";
by (best_tac FOL_cs 1); 
result();


writeln"Problems (mainly) involving equality or functions";

writeln"Problem 48";
goal cla_thy "(a=b | c=d) & (a=c | b=d) --> a=d | b=c";
by (fast_tac FOL_cs 1);
result();

writeln"Problem 49  NOT PROVED AUTOMATICALLY";
(*Hard because it involves substitution for Vars;
  the type constraint ensures that x,y,z have the same type as a,b,u. *)
goal cla_thy "(EX x y::'a. ALL z. z=x | z=y) & P(a) & P(b) & (~a=b) \
\		--> (ALL u::'a.P(u))";
by (safe_tac FOL_cs);
by (res_inst_tac [("x","a")] allE 1);
ba 1;
by (res_inst_tac [("x","b")] allE 1);
ba 1;
by (fast_tac FOL_cs 1);
result();

writeln"Problem 50";  
(*What has this to do with equality?*)
goal cla_thy "(ALL x. P(a,x) | (ALL y.P(x,y))) --> (EX x. ALL y.P(x,y))";
by (best_tac FOL_dup_cs 1);
result();

writeln"Problem 51";
goal cla_thy
    "(EX z w. ALL x y. P(x,y) <->  (x=z & y=w)) -->  \
\    (EX z. ALL x. EX w. (ALL y. P(x,y) <-> y=w) <-> x=z)";
by (fast_tac FOL_cs 1);
result();

writeln"Problem 52";
(*Almost the same as 51. *)
goal cla_thy
    "(EX z w. ALL x y. P(x,y) <->  (x=z & y=w)) -->  \
\    (EX w. ALL y. EX z. (ALL x. P(x,y) <-> x=z) <-> y=w)";
by (best_tac FOL_cs 1);
result();

writeln"Problem 56";
goal cla_thy
    "(ALL x. (EX y. P(y) & x=f(y)) --> P(x)) <-> (ALL x. P(x) --> P(f(x)))";
by (fast_tac FOL_cs 1);
result();

writeln"Problem 57";
goal cla_thy
    "P(f(a,b), f(b,c)) & P(f(b,c), f(a,c)) & \
\    (ALL x y z. P(x,y) & P(y,z) --> P(x,z))    -->   P(f(a,b), f(a,c))";
by (fast_tac FOL_cs 1);
result();

writeln"Problem 58  NOT PROVED AUTOMATICALLY";
goal cla_thy "(ALL x y. f(x)=g(y)) --> (ALL x y. f(f(x))=f(g(y)))";
val f_cong = read_instantiate [("t","f")] subst_context;
by (fast_tac (FOL_cs addIs [f_cong]) 1);
result();

writeln"Problem 59";
goal cla_thy "(ALL x. P(x) <-> ~P(f(x))) --> (EX x. P(x) & ~P(f(x)))";
by (best_tac FOL_dup_cs 1);
result();

writeln"Problem 60";
goal cla_thy
    "ALL x. P(x,f(x)) <-> (EX y. (ALL z. P(z,y) --> P(z,f(x))) & P(x,y))";
by (fast_tac FOL_cs 1);
result();

writeln"Reached end of file.";

(*Thu Jul 23 1992: loaded in 467.1s using iffE*)
