(*  Title: 	Pure/SYNTAX/xgram
    Author: 	Tobias Nipkow
    Copyright   1991  University of Cambridge

External Grammar Representation
*)

signature XGRAM =
sig
  structure Symtab: SYMTAB
  datatype 'a XSymb = Terminal of 'a | Nonterminal of string * int |
			Space of string |
			Bg of int | Brk of int | En
  datatype 'a Prod = Prod of string * ('a XSymb list) * string * int
  datatype 'a XGram = XGram of {Roots: string list,
                                TrTab1: (term list -> term) Symtab.table,
                                TrTab2: (term list -> term) Symtab.table,
				TMixFixs: string list,
                                Prods: 'a Prod list}
  val terminals: 'a XSymb list -> 'a list
  val nonterminals: 'a XSymb list -> string list
  val translate: ('a -> 'b) -> 'a XSymb list -> 'b XSymb list
  val copy_pri: int
end;

(* Terminal(a): terminal a
   Nonterminal(s,p): nonterminal named s; require priority >= p
   Space(s): some white space for printing
   Bg, Brk, En: see resp. routines in Pretty
*)
(* Prod(lhs,rhs,opn,p):
   lhs: name of nonterminal on the lhs of the production
   rhs: sequence of symbols on the rhs of the production
   opn: name of the corresponding Isabelle Const.
   p: priority of this production, 0 <= p <= max_pri
*)

functor XGramFun(Symtab:SYMTAB) : XGRAM =
struct

structure Symtab = Symtab;

datatype 'a XSymb = Terminal of 'a | Nonterminal of string * int |
			Space of string |
			Bg of int | Brk of int | En;

datatype 'a Prod = Prod of string * ('a XSymb list) * string * int;

datatype 'a XGram = XGram of {Roots: string list,
                              TrTab1: (term list -> term) Symtab.table,
                              TrTab2: (term list -> term) Symtab.table,
			      TMixFixs: string list,
                              Prods: 'a Prod list};

val copy_pri = ~1; (* must be < all legal priorities, i.e. 0 *)

fun terminals [] = []
  | terminals (Terminal(s)::sl) = s::terminals(sl)
  | terminals (_::sl) = terminals(sl);

fun nonterminals [] = []
  | nonterminals (Nonterminal(s,_)::sl) = s::nonterminals(sl)
  | nonterminals (_::sl) = nonterminals(sl);

fun translate trfn = map (fn Terminal(t) => Terminal(trfn t)
                           | Nonterminal(s) => Nonterminal(s)
                           | Space(s) => Space(s)
			   | Bg(i) => Bg(i) | Brk(i) => Brk(i) | En => En);

end;
