(*  Title: 	NJ
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Compatibility file for Standard ML of New Jersey, version 0.66.
*)

(*** Poly/ML emulation ***)

(*To exit the system -- an alternative to ^D *)
val quit = System.Unsafe.CInterface.exit;

(*To change the current directory*)
val cd = System.Directory.cd;

(*To limit the printing depth [divided by 2 for comparibility with Poly/ML]*)
fun print_depth n = (System.Control.Print.printDepth := n div 2;
		     System.Control.Print.printLength := n);

(*Only works in Poly/ML at present*)
fun install_pp f = ();

(*** New Jersey ML parameters ***)

(* This parameter setting depends upon how much memory you have!!! *)
System.Control.Runtime.softmax := 10000000;

(* Suppresses Garbage Collection messages;  default was 2 *)
System.Control.Runtime.gcmessages := 0;

(*redefine to flush its output immediately -- temporary patch suggested
  by Kim Dam Petersen*)
val output = fn(s,t) => (output(s,t); flush_out s);


(*** Timing functions ***)

(*Print microseconds, suppressing trailing zeroes*)
fun umakestring 0 = ""
  | umakestring n = chr(ord"0" + n div 100000) ^ 
		    umakestring(10 * (n mod 100000));

(*A conditional timing function: applies f to () and, if the flag is true,
  prints its runtime. *)
fun cond_timeit flag f =
  if flag then
    let fun string_of_time (System.Timer.TIME {sec,usec}) =
	    makestring sec ^ "." ^ (if usec=0 then "0" else umakestring usec)
	open System.Timer;
	val start = start_timer()
	val result = f();
	val nongc = check_timer(start)
	and gc = check_timer_gc(start);
	val both = add_time(nongc,gc)
    in  print("Non GC " ^ string_of_time nongc ^
	       "   GC " ^ string_of_time gc ^
	       "  both "^ string_of_time both ^ " secs\n");
	result
    end
  else f();

(*Unconditional timing function*)
val timeit = cond_timeit true;
