(*  Title: 	HOL/subset
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Derived rules involving subsets
Union and Intersection as lattice operations
*)

(*** Big Union -- least upper bound of a set  ***)

val prems = goal Set.thy
    "B:A ==> B <= Union(A)";
by (REPEAT (ares_tac (prems@[subsetI,UnionI]) 1));
val Union_upper = result();

val prems = goal Set.thy
    "[| !!X. X:A ==> X<=C |] ==> Union(A) <= C";
by (REPEAT (ares_tac [subsetI] 1
     ORELSE eresolve_tac ([UnionE] @ (prems RL [subsetD])) 1));
val Union_least = result();


(*** Big Intersection -- greatest lower bound of a set ***)

val prems = goal Set.thy
    "B:A ==> Inter(A) <= B";
by (REPEAT (resolve_tac (prems@[subsetI]) 1
     ORELSE etac InterD 1));
val Inter_lower = result();

val prems = goal Set.thy
    "[| !!X. X:A ==> C<=X |] ==> C <= Inter(A)";
by (REPEAT (ares_tac [subsetI,InterI] 1
     ORELSE eresolve_tac (prems RL [subsetD]) 1));
val Inter_greatest = result();

(*** Finite Union -- the least upper bound of 2 sets ***)

goal Set.thy "A <= A Un B";
by (REPEAT (ares_tac [subsetI,UnI1] 1));
val Un_upper1 = result();

goal Set.thy "B <= A Un B";
by (REPEAT (ares_tac [subsetI,UnI2] 1));
val Un_upper2 = result();

val prems = goal Set.thy "[| A<=C;  B<=C |] ==> A Un B <= C";
by (cut_facts_tac prems 1);
by (DEPTH_SOLVE (ares_tac [subsetI] 1 
          ORELSE eresolve_tac [UnE,subsetD] 1));
val Un_least = result();

(*** Finite Intersection -- the greatest lower bound of 2 sets *)

goal Set.thy "A Int B <= A";
by (REPEAT (ares_tac [subsetI] 1 ORELSE etac IntE 1));
val Int_lower1 = result();

goal Set.thy "A Int B <= B";
by (REPEAT (ares_tac [subsetI] 1 ORELSE etac IntE 1));
val Int_lower2 = result();

val prems = goal Set.thy "[| C<=A;  C<=B |] ==> C <= A Int B";
by (cut_facts_tac prems 1);
by (REPEAT (ares_tac [subsetI,IntI] 1
     ORELSE etac subsetD 1));
val Int_greatest = result();

val set_cs = HOL_cs 
    addSIs [ballI, subsetI, InterI, INT_I, CollectI, 
	    ComplI, IntI, UnCI, singletonI] 
    addIs  [bexI, UnionI, UN_I, imageI, rangeI] 
    addSEs [bexE, UnionE, UN_E,
	    CollectE, ComplE, IntE, UnE, singletonE, imageE, rangeE ] 
    addEs  [ballE, InterD, InterE, INT_D, INT_E, subsetD, subsetCE];

fun cfast_tac prems = cut_facts_tac prems THEN' fast_tac set_cs;
