(*  Title: 	FOL/ex/prop
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

First-Order Logic: propositional examples (intuitionistic and classical)
Needs declarations of the theory "thy" and the tactic "tac"
*)

writeln"File FOL/ex/prop.";


writeln"commutative laws of & and | ";
goal thy "P & Q  -->  Q & P";
by tac;
result();

goal thy "P | Q  -->  Q | P";
by tac;
result();


writeln"associative laws of & and | ";
goal thy "(P & Q) & R  -->  P & (Q & R)";
by tac;
result();

goal thy "(P | Q) | R  -->  P | (Q | R)";
by tac;
result();



writeln"distributive laws of & and | ";
goal thy "(P & Q) | R  --> (P | R) & (Q | R)";
by tac;
result();

goal thy "(P | R) & (Q | R)  --> (P & Q) | R";
by tac;
result();

goal thy "(P | Q) & R  --> (P & R) | (Q & R)";
by tac;
result();


goal thy "(P & R) | (Q & R)  --> (P | Q) & R";
by tac;
result();


writeln"Laws involving implication";

goal thy "(P-->R) & (Q-->R) <-> (P|Q --> R)";
by tac;
result();


goal thy "(P & Q --> R) <-> (P--> (Q-->R))";
by tac;
result();


goal thy "((P-->R)-->R) --> ((Q-->R)-->R) --> (P&Q-->R) --> R";
by tac;
result();

goal thy "~(P-->R) --> ~(Q-->R) --> ~(P&Q-->R)";
by tac;
result();

goal thy "(P --> Q & R) <-> (P-->Q)  &  (P-->R)";
by tac;
result();


writeln"Propositions-as-types";

(*The combinator K*)
goal thy "P --> (Q --> P)";
by tac;
result();

(*The combinator S*)
goal thy "(P-->Q-->R)  --> (P-->Q) --> (P-->R)";
by tac;
result();


(*Converse is classical*)
goal thy "(P-->Q) | (P-->R)  -->  (P --> Q | R)";
by tac;
result();

goal thy "(P-->Q)  -->  (~Q --> ~P)";
by tac;
result();


writeln"Reached end of file.";
