(*  Title: 	FOL/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Adds First-Order Logic to a database containing pure Isabelle. 
Should be executed in the subdirectory FOL.
*)

writeln"Root file for First-Order Logic";

print_depth 1;  
use ".rules.ML";
use "int-lemmas.ML";
use "cla-lemmas.ML";
use "../Provers/hypsubst.ML";
use "../Provers/classical.ML";
use "../Provers/simp.ML";
use "../Provers/ind.ML";

structure Int_Rule = Int_RuleFun();
structure Int_Lemmas = Int_LemmasFun(Int_Rule);
structure Cla_Lemmas = 
     Cla_LemmasFun(structure Int_Rule=Int_Rule and Int_Lemmas=Int_Lemmas);

open Int_Rule Int_Lemmas Cla_Lemmas;


(*** Applying HypsubstFun to generate hyp_subst_tac ***)

structure Hypsubst_Data =
  struct
  (*Take apart an equality judgement; otherwise raise Match!*)
  fun dest_eq (Const("Trueprop",_) $ (Const("op =",_)  $ t $ u)) = (t,u);

  val imp_intr = impI

  (*etac rev_cut_eq moves an equality to be the last premise. *)
  val rev_cut_eq = prove_goal Int_Rule.thy "[| a=b;  a=b ==> R |] ==> R"
   (fn prems => [ REPEAT(resolve_tac prems 1) ]);

  val rev_mp = rev_mp
  val subst = subst
  val sym = sym
  end;

structure Hypsubst = HypsubstFun(Hypsubst_Data);
open Hypsubst;

use "int-prover.ML";

(*** Applying ClassicalFun to create a classical prover ***)
structure Classical_Data = 
  struct
  val sizef = size_of_thm
  val mp = mp
  val not_elim = notE
  val swap = swap
  val hyp_subst_tacs=[hyp_subst_tac]
  end;

structure Cla = ClassicalFun(Classical_Data);
open Cla;

(*Propositional rules 
  -- iffCE might seem better, but in the examples in ex/cla
     run about 7% slower than with iffE*)
val prop_cs = empty_cs addSIs [refl,TrueI,conjI,disjCI,impI,notI,iffI] 
                       addSEs [conjE,disjE,impCE,FalseE,iffE];

(*Quantifier rules*)
val FOL_cs = prop_cs addSIs [allI] addIs [exI,ex1I] 
                     addSEs [exE,ex1E] addEs [allE];

val FOL_dup_cs = prop_cs addSIs [allI] addIs [exCI,ex1I] 
                         addSEs [exE,ex1E] addEs [all_dupE];

use "simpdata.ML";

(* Set up automatic printing -- works in Poly/ML only *)
install_pp (K print_thm);   				(*theorems*)
install_pp (K prin);        				(*terms*)
install_pp (K (writeln o Sign.string_of_cterm));	(*cterms*)
print_depth 8;
