(*  Title: 	ZF/ex/misc
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

Miscellaneous examples Zermelo-Fraenkel Set Theory 
*)

writeln"ZF/ex/misc";


(*** Cantor's Theorem: There is no surjection from a set to its powerset. ***)

val cantor_cs = FOL_cs   (*precisely the rules needed for the proof*)
  addSIs [ballI, CollectI, PowI, subsetI] addIs [bexI]
  addSEs [CollectE, equalityCE, apply_type];

goal ZF_Rule.thy "ALL f: A->Pow(A). EX S: Pow(A). ALL x:A. ~ f`x = S";
by (best_tac cantor_cs 1);
result();

(*This form displays the diagonal term*)
val [prem] = goal ZF_Rule.thy
    "f: A->Pow(A) ==> (ALL x:A. ~ f`x = ?S) & ?S: Pow(A)";
by (best_tac (cantor_cs addSIs [prem RS apply_type]) 1);
result();



(*** Composition of homomorphisms is a homomorphism ***)

(*Given as a challenge problem in
  R. Boyer et al.,
  Set Theory in First-Order Logic: Clauses for G\"odel's Axioms,
  JAR 2 (1986), 287-327 

Variations: hom_def could be a meta-equality; could use (safe_tac ZF_cs)
*)

val [hom_def] = goal Perm.thy
    "(ALL h A f B g. hom(h,A,f,B,g) <-> \
\          h: A->B & f:A*A->A & g:B*B->B & \
\          (ALL x:A. ALL y:A. h`(f`<x,y>) = g`<h`x,h`y>)) ==> \
\    hom(h1,A1,f1,A2,f2) & hom(h2,A2,f2,A3,f3) -->  \
\    hom(h2 O h1, A1, f1, A3, f3)";
val hom_ss = set_auto_tac(
	ZF_ss addrews [hom_def,comp_func,comp_func_apply, SigmaI,apply_type]
   	      addcongs (mk_congs Perm.thy ["op O"]),
	DEPTH_SOLVE_1 o (ares_tac [TrueI,ballI] ORELSE' eresolve_tac [conjE]));
by (SIMP_TAC hom_ss 1);
val comp_homs = result();

writeln"Reached end of file.";
