(*  Title: 	ZF/equalities
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

Set Theory examples: Union, Intersection, Inclusion, etc.
    (Thanks also to Philippe de Groote.)
*)

writeln"File ZF/equalities";

val eq_cs = ZF_cs addSIs [equalityI];

(** Finite Sets **)

goal ZF_Rule.thy "cons(a, cons(b, C)) = cons(b, cons(a, C))";
by (fast_tac eq_cs 1);
val cons_commute = result();


(** Binary Intersection **)

goal ZF_Rule.thy "A Int A = A";
by (fast_tac eq_cs 1);
val Int_absorb = result();

goal ZF_Rule.thy "A Int B = B Int A";
by (fast_tac eq_cs 1);
val Int_commute = result();

goal ZF_Rule.thy "(A Int B) Int C  =  A Int (B Int C)";
by (fast_tac eq_cs 1);
val Int_assoc = result();

goal ZF_Rule.thy "(A Un B) Int C  =  (A Int C) Un (B Int C)";
by (fast_tac eq_cs 1);
val Int_Un_distrib = result();

goal ZF_Rule.thy "A<=B <-> A Int B = A";
by (fast_tac (eq_cs addSEs [equalityE]) 1);
val subset_Int_iff = result();

(** Binary Union **)

goal ZF_Rule.thy "A Un A = A";
by (fast_tac eq_cs 1);
val Un_absorb = result();

goal ZF_Rule.thy "A Un B = B Un A";
by (fast_tac eq_cs 1);
val Un_commute = result();

goal ZF_Rule.thy "(A Un B) Un C  =  A Un (B Un C)";
by (fast_tac eq_cs 1);
val Un_assoc = result();

goal ZF_Rule.thy "(A Int B) Un C  =  (A Un C) Int (B Un C)";
by (fast_tac eq_cs 1);
val Un_Int_distrib = result();

goal ZF_Rule.thy "A<=B <-> A Un B = B";
by (fast_tac (eq_cs addSEs [equalityE]) 1);
val subset_Un_iff = result();

(** Simple properties of Diff -- set difference **)

goal ZF_Rule.thy "A-A = 0";
by (fast_tac eq_cs 1);
val Diff_cancel = result();

goal ZF_Rule.thy "A Int (B-A) = 0";
by (fast_tac eq_cs 1);
val Diff_disjoint = result();

val prems = goal ZF_Rule.thy
    "A<=B ==> A Un (B-A) = B";
by (cut_facts_tac prems 1);
by (fast_tac eq_cs 1);
val Diff_partition = result();

val prems = goal ZF_Rule.thy
    "[| A<=B; B<= C |] ==> (B - (C-A)) = A";
by (cut_facts_tac prems 1);
by (fast_tac eq_cs 1);
val double_complement = result();

goal ZF_Rule.thy
 "(A Int B) Un (B Int C) Un (C Int A) = (A Un B) Int (B Un C) Int (C Un A)";
by (fast_tac eq_cs 1);
val Un_Int_crazy = result();

goal ZF_Rule.thy "A - (B Un C) = (A-B) Int (A-C)";
by (fast_tac eq_cs 1);
val Diff_Un = result();

goal ZF_Rule.thy "A - (B Int C) = (A-B) Un (A-C)";
by (fast_tac eq_cs 1);
val Diff_Int = result();

(*Halmos, Naive Set Theory, page 16.*)
goal ZF_Rule.thy "(A Int B) Un C = A Int (B Un C)  <->  C<=A";
by (fast_tac (eq_cs addSEs [equalityE]) 1);
val Un_Int_assoc_iff = result();


(** Big Union and Intersection **)

goal ZF_Rule.thy "Union(A Un B) = Union(A) Un Union(B)";
by (fast_tac eq_cs 1);
val Union_Un_distrib = result();

goal ZF_Rule.thy "Union(C) Int A = 0 <-> (ALL B:C. B Int A = 0)";
by (fast_tac (eq_cs addSEs [equalityE]) 1);
val Union_disjoint = result();

(* A good challenge: Inter is ill-behaved on the empty set *)
val prems = goal ZF_Rule.thy
    "[| a:A;  b:B |] ==> Inter(A Un B) = Inter(A) Int Inter(B)";
by (cut_facts_tac prems 1);
by (fast_tac eq_cs 1);
val Inter_Un_distrib = result();

(** Unions and Intersections of Families **)

goal ZF_Rule.thy "A Int Union(B) = (UN C:B. A Int C)";
by (fast_tac eq_cs 1);
val Int_Union_RepFun = result();


(** Devlin, page 12: Union of a family of unions **)

goal ZF_Rule.thy "(UN x:C. A(x) Un B(x)) = (UN x:C. A(x))  Un  (UN x:C. B(x))";
by (fast_tac eq_cs 1);
val UN_Un_distrib = result();

val prems = goal ZF_Rule.thy "b:B ==> A Un Inter(B) = (INT C:B. A Un C)";
by (cut_facts_tac prems 1);
by (fast_tac eq_cs 1);
val Un_Inter_RepFun = result();

val prems = goal ZF_Rule.thy
    "c:C ==> (INT x:C. A(x)  Int  B(x)) = (INT x:C. A(x)) Int (INT x:C. B(x))";
by (cut_facts_tac prems 1);
by (fast_tac eq_cs 1);
val INT_Int_distrib = result();

(** Unions and Intersections with General Sum **)

goal ZF_Rule.thy "(SUM x:A Un B. C(x)) = (SUM x:A. C(x)) Un (SUM x:B. C(x))";
by (fast_tac eq_cs 1);
val SUM_Un_distrib1 = result();

goal ZF_Rule.thy
    "(SUM x:C. A(x) Un B(x)) = (SUM x:C. A(x)) Un (SUM x:C. B(x))";
by (fast_tac eq_cs 1);
val SUM_Un_distrib2 = result();

goal ZF_Rule.thy "(SUM x:A Int B. C(x)) = (SUM x:A. C(x)) Int (SUM x:B. C(x))";
by (fast_tac eq_cs 1);
val SUM_Int_distrib1 = result();

goal ZF_Rule.thy
    "(SUM x:C. A(x) Int B(x)) = (SUM x:C. A(x)) Int (SUM x:C. B(x))";
by (fast_tac eq_cs 1);
val SUM_Int_distrib2 = result();
