(*  Title: 	HOL/fixedpt
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

The Knaster-Tarski Theorem
*)

structure Fixedpt =
struct
val const_decs = 
 [
  (["lfp"],		 "['a set=>'a set] => 'a set")
 ];

val thy = extend_theory Sum.thy  "fixedpt" 
    ([], [], [], [], const_decs, None)
 [    
  ("lfp_def", "lfp(f) == Inter({u. f(u) <= u})")     (*least fixed point*)
 ];

end;

local val ax = get_axiom Fixedpt.thy
in
val lfp_def = ax"lfp_def";
end;

(*** Proof of Knaster-Tarski Theorem ***)

(* lfp(f) is the greatest lower bound of {u. f(u) <= u} *)

val prems = goalw Fixedpt.thy [lfp_def] "[| f(A) <= A |] ==> lfp(f) <= A";
by (rtac (CollectI RS Inter_lower) 1);
by (resolve_tac prems 1);
val lfp_lowerbound = result();

val prems = goalw Fixedpt.thy [lfp_def]
    "[| !!u. f(u) <= u ==> A<=u |] ==> A <= lfp(f)";
by (REPEAT (ares_tac ([Inter_greatest]@prems) 1));
by (etac CollectD 1);
val lfp_greatest = result();

val [mono] = goal Fixedpt.thy
    "[| mono(f) |] ==> f(lfp(f)) <= lfp(f)";
by (EVERY1 [rtac lfp_greatest, rtac subset_trans,
	    rtac (mono RS monoD), rtac lfp_lowerbound, atac, atac]);
val fix_lemma2 = result();

val [mono] = goal Fixedpt.thy
    "[| mono(f) |] ==> lfp(f) <= f(lfp(f))";
by (EVERY1 [rtac lfp_lowerbound, rtac (mono RS monoD), 
	    rtac fix_lemma2, rtac mono]);
val fix_lemma3 = result();

val [mono] = goal Fixedpt.thy
    "[| mono(f) |] ==> lfp(f) = f(lfp(f))";
by (REPEAT (resolve_tac [equalityI,fix_lemma2,fix_lemma3,mono] 1));
val Tarski_theorem = result();

(*Works well with definitions.  NOTE the !! hack to prevent == being
  taken as a constraint...  *)
val [rew,mono] = goal Fixedpt.thy
    "[| !!x. h==lfp(f);  mono(f) |] ==> h = f(h)";
by (rewtac rew);
by (rtac (mono RS Tarski_theorem) 1);
val Tarski_def_theorem = result();


(*** General induction rule for least fixed points ***)

val [lfp,mono,indhyp] = goal Fixedpt.thy
    "[| a: lfp(f);  mono(f);  \
\       !!x. [| x: f(lfp(f) Int {x.P(x)}) |] ==> P(x) \
\    |] ==> P(a)";
by (res_inst_tac [("a","a")] (Int_lower2 RS subsetD RS CollectD) 1);
by (rtac (lfp RSN (2, lfp_lowerbound RS subsetD)) 1);
by (EVERY1 [rtac Int_greatest, rtac subset_trans, 
	    rtac (Int_lower1 RS (mono RS monoD)),
	    rtac (mono RS fix_lemma2),
	    rtac (CollectI RS subsetI), rtac indhyp, atac]);
val general_induction = result();

(*Monotonicity of lfp!*)
val prems = goal Fixedpt.thy
    "[| mono(g);  !!Z. f(Z)<=g(Z) |] ==> lfp(f) <= lfp(g)";
by (rtac lfp_lowerbound 1);
by (rtac subset_trans 1);
by (resolve_tac prems 1);
by (rtac fix_lemma2 1);
by (resolve_tac prems 1);
val lfp_mono = result();
