(*  Title: 	HOL/ruleshell
    Author: 	Tobias Nipkow
    Copyright   1992  University of Cambridge

Natural Deduction Rules for Higher-order logic 

After updating, rebuild  ".rules.ML"  by calling   "make-rulenames"   
*)


signature HOL_RULE =
  sig
  val sign: Sign.sg
  val thy: theory
  val HOL_quantifiers: bool ref
  val alt_tr': ('a -> 'b) * ('a -> 'b) -> 'a -> 'b
(*INSERT-RULESIG -- file produced by make-rulenames*)
  val refl: thm
  val subst: thm
  val abs: thm
  val selectI: thm
  val impI: thm
  val mp: thm
  val True_def: thm
  val All_def: thm
  val Ex_def: thm
  val False_def: thm
  val not_def: thm
  val and_def: thm
  val or_def: thm
  val Ex1_def: thm
  val iff: thm
  val True_or_False: thm
  val Inv_def: thm
  val o_def: thm
  val if_def: thm
  end;


functor HOL_RuleFun () : HOL_RULE = 
struct

val mixfix =
 [Mixfix("(_)",	"bool => prop",	"Trueprop", [0], 5),
      (*Primitive Constants*)
  Infixl("=",	"['a,'a] => bool", 		50),
  Infixr("-->",	"[bool,bool] => bool", 		25),
  Binder("@",	"('a => bool) => 'a", "Eps", 0, 	10),
      (* Defined Constants *)
  Infixr("o",	"['b=>'c, 'a=>'b, 'a] => 'c", 	50),
  Mixfix("~ _",	"bool => bool", "not", [40],	40),
  Infixr("&",	"[bool,bool] => bool", 		35),
  Infixr("|",	"[bool,bool] => bool", 		30),

(* Effect is similar to the following, but allows both syntaxes
  Binder("! ",	"('a => bool) => bool", "All", 0, 10),
  Binder("? ",	"('a => bool) => bool", "Ex", 0, 10),
  Binder("?! ",	"('a => bool) => bool", "Ex1", 0, 10)
*)
  Mixfix("(3! _./ _)",	"[IDT_LIST, bool] => bool", "@All", [0,0], 10),
  Mixfix("(3ALL _./ _)","[IDT_LIST, bool] => bool", "*All", [0,0], 10),
  Mixfix("(3? _./ _)",	"[IDT_LIST, bool] => bool", "@Ex", [0,0], 10),
  Mixfix("(3EX _./ _)", "[IDT_LIST, bool] => bool", "*Ex", [0,0], 10),
  Mixfix("(3?! _./ _)",	"[IDT_LIST, bool] => bool", "@Ex1", [0,0], 10),
  Mixfix("(3EX! _./ _)","[IDT_LIST, bool] => bool", "*Ex1", [0,0], 10)
  ];


(** Choice between the HOL and Isabelle style of quantifiers **)

val HOL_quantifiers = ref true;

fun alt_tr' (tr1',tr2') ts = if !HOL_quantifiers then tr1' ts else tr2' ts;

fun mk_bindopt_tr' name =
  let val (_, tr1') = mk_binder_tr' (name, "@"^name)
      and (_, tr2') = mk_binder_tr' (name, "*"^name)
  in  (name, alt_tr' (tr1',tr2'))  end;

val sext = 
  Sext{mixfix=mixfix,
       parse_translation = 
         map mk_binder_tr [("@All","All"), ("@Ex","Ex"), ("@Ex1","Ex1"),
			   ("*All","All"), ("*Ex","Ex"), ("*Ex1","Ex1")],
       print_translation = 
	 map mk_bindopt_tr' ["All", "Ex", "Ex1"]};

val const_decs =
[ (["All","Ex","Ex1"], 		"['a=>bool]=>bool"),  (*quantifiers*)
  (["True","False"], 		"bool"),
  (["if"], 			"[bool,'a,'a] => 'a"),
  (["Inv"], 			"('a => 'b)  =>  ('b => 'a)")
];

val thy = extend_theory pure_thy "HOL"
([("term",["logic"])(*, ("bool", ["term"]*)],
 ["term"],
 [(["fun"], ([["term"],["term"]],"term"))],
 [(["bool"],([],"term"))],
 const_decs,
 Some(sext))
[
  (*Basic Rules*)

  ("refl",	"t = t::'a"  ),
  ("subst",	"[| s = t; P(s) |] ==> P(t::'a)"  ),
  ("abs",  	"(!!x::'a. f(x)::'b = g(x)) ==> (%x.f(x)) = (%x.g(x))"),
  ("selectI",	"P(x::'a) ==> P(@x.P(x))"  ),

  ("impI",	"(P ==> Q) ==> P-->Q"  ),
  ("mp",	"[| P-->Q;  P |] ==> Q"  ),

  (* Definitions *)

  ("True_def",	"True = ((%x.x)=(%x.x))"  ),
  ("All_def",	"All  = (%P. P = (%x.True))"  ),
  ("Ex_def",	"Ex   = (%P. P(@x.P(x)))"  ),
  ("False_def",	"False = (!P.P)"  ),
  ("not_def",	"not  = (%P. P-->False)"  ),
  ("and_def",	"op & = (%P Q. !R. (P-->Q-->R) --> R)"  ),
  ("or_def",	"op | = (%P Q. !R. (P-->R) --> (Q-->R) --> R)"  ),
  ("Ex1_def",	"Ex1  = (%P. ? x. P(x) & (! y. P(y) --> y=x))"  ),

  (* Axioms*)

  ("iff",		"(P-->Q) --> (Q-->P) --> (P=Q)" ),
  ("True_or_False",	"(P=True) | (P=False)"  ),

  (*Misc Definitions*)

  ("Inv_def",	"Inv = (%(f::'a=>'b) y. @x. f(x)=y)"  ),
  ("o_def",	"op o = (%(f::'b=>'c) g (x::'a). f(g(x)))"  ),

  ("if_def",	
   "if = (%P x y.@z::'a. (P=True --> z=x) & (P=False --> z=y))" )
];

val sign = sign_of thy;
val ax = get_axiom thy;

(*INSERT-RULENAMES -- file produced by make-rulenames*)
val refl = ax"refl";
val subst = ax"subst";
val abs = ax"abs";
val selectI = ax"selectI";
val impI = ax"impI";
val mp = ax"mp";
val True_def = ax"True_def";
val All_def = ax"All_def";
val Ex_def = ax"Ex_def";
val False_def = ax"False_def";
val not_def = ax"not_def";
val and_def = ax"and_def";
val or_def = ax"or_def";
val Ex1_def = ax"Ex1_def";
val iff = ax"iff";
val True_or_False = ax"True_or_False";
val Inv_def = ax"Inv_def";
val o_def = ax"o_def";
val if_def = ax"if_def";

end;
