(*  Title: 	FOL/ex/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Executes all examples for First-Order Logic. 
*)

writeln"Root file for FOL examples";

proof_timing := true;

use "ex/intro.ML";
use "ex/foundn.ML";
use "ex/prolog.ML";

writeln"\n** Intuitionistic examples **\n";
use "ex/int.ML";

val thy = Int_Rule.thy  and  tac = Int.fast_tac 1;
use "ex/prop.ML";
use "ex/quant.ML";

writeln"\n** Classical examples **\n";
use "ex/cla.ML";
use "ex/if.ML";

val thy = cla_thy  and  tac = Cla.fast_tac FOL_cs 1;
use "ex/prop.ML";
use "ex/quant.ML";

writeln"\n** Simplification examples **\n";

use "ex/nat.ML";
use "ex/list.ML";

maketest"END: Root file for FOL examples";
