(*  Title: 	ZF/pair
    Author: 	Martin D Coen, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Ordered pairs in Zermelo-Fraenkel Set Theory 
*)

(** Lemmas for showing that <a,b> uniquely determines a and b **)

val prems = goal set_thy "[| {a,b} <= C; [| a : C;  b : C |] ==> P |] ==> P";
by (cut_facts_tac prems 1);
by (REPEAT (etac subsetD 1 
     ORELSE ares_tac (prems@[consI1,consI2]) 1));
val doubleton_lemma = result();

val prems = goal set_thy "{a,b} = {c,d} <-> (a=c & b=d) | (a=d & b=c)";
by (resolve_tac [extension RS iff_trans] 1);
by (fast_tac (upair_cs addEs [doubleton_lemma]) 1);
val doubleton_iff = result();

val major::prems = goal set_thy
    "[| {a,b} = {c,d};  \
\       [| a=c; b=d |] ==> P; [| a=d; b=c |] ==> P |] ==> \
\    P";
br (major RS (doubleton_iff RS iffD2 RS disjE)) 1;
by (REPEAT (eresolve_tac ([asm_rl, conjE] @ prems) 1));
val doubleton_equality = result();

val prems = goalw set_thy [Pair_def] "<a,b> = <c,d> ==> a=c";
by (cut_facts_tac prems 1);
by (REPEAT (atac 1 ORELSE etac doubleton_equality 1));
val Pair_inject1 = result();

val prems = goalw set_thy [Pair_def] "<a,b> = <c,d> ==> b=d";
by (cut_facts_tac prems 1);
by (fast_tac (upair_cs addEs [doubleton_equality]) 1);
val Pair_inject2 = result();

val [major,minor] = goal set_thy
    "[| <a,b> = <c,d>;  [| a=c; b=d |] ==> P |] ==> P";
br minor 1;
br (major RS Pair_inject1) 1;
br (major RS Pair_inject2) 1;
val Pair_inject = result();

val [major] = goalw set_thy [Pair_def] "<a,b>=0 ==> P";
by (rtac (major RS equalityD1 RS subsetD RS emptyE) 1);
by (rtac consI1 1);
val Pair_neq_0 = result();


(*** fst and snd ***)

val prems = goalw set_thy [fst_def] "fst(<a,b>) = a";
by (fast_tac (upair_cs addIs [the_equality] addEs [Pair_inject]) 1);
val fst_conv = result();

val prems = goalw set_thy [snd_def] "snd(<a,b>) = b";
by (fast_tac (upair_cs addIs [the_equality] addEs [Pair_inject]) 1);
val snd_conv = result();


(*** Disjoint union of a family of sets - Sigma ***)

val prems = goalw set_thy [Sigma_def]
    "[| a:A;  b:B(a) |] ==> <a,b> : (SUM x:A. B(x))";
by (fast_tac (upair_cs addIs prems) 1);
val SigmaI = result();

(*The general elimination rule*)
val major::prems = goalw set_thy [Sigma_def]
    "[| c: (SUM x:A. B(x));  \
\       !!x y.[| x:A;  y:B(x);  c=<x,y> |] ==> P \
\    |] ==> P";
by (cut_facts_tac [major] 1);
by (REPEAT (eresolve_tac [UN_E, singletonE] 1 ORELSE ares_tac prems 1));
val SigmaE = result();

(*Elimination of <a,b>:A*B -- introduces no eigenvariables*)
val prems = goal set_thy
    "[| <a,b> : (SUM x:A. B(x));    \
\       [| a:A;  b:B(a) |] ==> P   \
\    |] ==> P";
by (rtac SigmaE 1);
by (REPEAT (ares_tac prems 1 ORELSE eresolve_tac [Pair_inject,ssubst] 1));
val SigmaE2 = result();

val prems = goalw set_thy [Sigma_def]
    "[| A=A';  !!x. x:A' ==> B(x)=B'(x) |] ==> \
\    (SUM x:A. B(x)) = (SUM x:A'. B'(x))";
by (prove_cong_tac (prems@[RepFun_cong]) 1);
val Sigma_cong = result();

goal set_thy "Sigma(0,B) = 0";
by (REPEAT (eresolve_tac [SigmaE,emptyE] 1
     ORELSE ares_tac [equalityI,subsetI] 1));
val Sigma_empty1 = result();

goal set_thy "A*0 = 0";
by (REPEAT (eresolve_tac [SigmaE,emptyE] 1
     ORELSE ares_tac [equalityI,subsetI] 1));
val Sigma_empty2 = result();


(** Eliminator - split **)

goalw set_thy [split_def] "split(<a,b>, %x y.c(x,y)) = c(a,b)";
by (fast_tac (upair_cs addIs [the_equality] addEs [Pair_inject]) 1);
val split_conv = result();

val major::prems = goal set_thy
    "[|  p:(SUM x:A. B(x));   \
\        !!x y.[| x:A; y:B(x) |] ==> c(x,y):C(<x,y>) \
\    |] ==> split(p, %x y.c(x,y)) : C(p)";
br (major RS SigmaE) 1;
by (etac ssubst 1);
by (REPEAT (ares_tac (prems @ [split_conv RS ssubst]) 1));
val split_type = result();

(*This congruence rule uses typing information...*)
val prems = goalw set_thy [split_def] 
    "[| p=p';  !!x y.c(x,y) = c'(x,y) |] ==> \
\    split(p, %x y.c(x,y)) = split(p', %x y.c'(x,y))";
by (prove_cong_tac (prems@[the_cong]) 1);
val split_cong = result();
