(*  Title: 	ZF/ex/univ
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

A universe for recursive data types in Set Theory
*)

writeln"File ZF/ex/univ";

structure Univ =
struct
val const_decs = 
    [ (["univ"],	"i=>i") ];

val thy = extend_theory Arith.thy "univ"
     ([], [], [], const_decs, None)
 [ 
  ("univ_def",	"univ(A) == UN n:nat. nat_rec(n, A, %m r. r Un Pow(r))")
 ];
end;

local val ax = get_axiom Univ.thy
in 
val univ_def = ax"univ_def";
end;

(** Basic closure properties **)

goalw Univ.thy [univ_def] "0 : univ(A)";
by (rtac (nat_0_I RS nat_succ_I RS UN_I) 1);
by (rtac (nat_0_I RS nat_rec_succ_conv RS ssubst) 1);
by (rtac (Pow_bottom RS UnI2) 1);
val zero_in_univ = result();

val prems = goalw Univ.thy [univ_def] "a: A  ==> a: univ(A)";
by (EVERY1 [ rtac (nat_0_I RS UN_I),
	     rtac (nat_rec_0_conv RS ssubst),
	     resolve_tac prems ]);
val A_in_univ = result();

goal Univ.thy "A <= univ(A)";
by (rtac subsetI 1);
by (etac A_in_univ 1);
val A_subset_univ = result();

(* singletons and doubletons *)

val [major] = goalw Univ.thy [univ_def] "a: univ(A) ==> {a} : univ(A)";
by (rtac (major RS UN_E) 1);
by (rtac UN_I 1);
by (etac nat_succ_I 1);
by (etac (nat_rec_succ_conv RS ssubst) 1);
by (REPEAT (ares_tac [UnI2,PowI,subsetI] 1
     ORELSE eresolve_tac [singletonE,ssubst] 1));
val singleton_in_univ = result();

val prems = goal Univ.thy
    "[| m<=n;  m: nat;  n: nat |] ==> \
\    nat_rec(m, A, %k r. r Un Pow(r)) <= nat_rec(n, A, %k r. r Un Pow(r))";
by (EVERY1 [ cut_facts_tac prems,
	     etac nat_induct3,
	     atac, atac,
	     rtac subset_refl,
	     etac subset_trans,
	     rtac (nat_rec_succ_conv RS ssubst),
	     atac,
	     rtac subsetI,
	     etac UnI1 ]);
val univfun_cumulative = result();

val prems = goalw Univ.thy [univ_def]
    "[| a: univ(A);  b: univ(A) |] ==> {a,b} : univ(A)";
by (EVERY1 (map rtac (prems RL [UN_E])));
by (rtac UN_I 1);
by (res_inst_tac [("n","?X Un ?Y")] nat_succ_I 1);
by (rtac (nat_rec_succ_conv RS ssubst) 2);
by (DEPTH_SOLVE (ares_tac [Un_nat_type, subsetI RS PowI RS UnI2] 1
     ORELSE eresolve_tac [emptyE,consE,ssubst] 1
     ORELSE resolve_tac [Un_upper1 RS univfun_cumulative RS subsetD,
			 Un_upper2 RS univfun_cumulative RS subsetD] 1));
val doubleton_in_univ = result();

(** Closure under finite Cartesian Products **)

val prems = goalw Univ.thy [Pair_def]
    "[| a: univ(A);  b: univ(A) |] ==> <a,b> : univ(A)";
by (REPEAT (resolve_tac (prems@[doubleton_in_univ]) 1));
val pair_in_univ = result();

val prems = goal Univ.thy "[| B<=univ(A);  C<=univ(A) |] ==> B*C <= univ(A)";
by (rtac (product_mono RS subset_trans) 1);
by (REPEAT (ares_tac (prems@[subsetI,pair_in_univ]) 1
     ORELSE eresolve_tac [SigmaE, ssubst] 1));
val product_subset_univ = result();


(** Closure under disjoint union **)

val prems = goalw Univ.thy [Inl_def]
    "a: univ(A) ==> Inl(a) : univ(A)";
by (REPEAT (resolve_tac (prems@[zero_in_univ,pair_in_univ]) 1));
val Inl_in_univ = result();

val prems = goalw Univ.thy [Inr_def]
    "b: univ(A) ==> Inr(b) : univ(A)";
by (REPEAT (resolve_tac (prems@[zero_in_univ,singleton_in_univ,
				pair_in_univ]) 1));
val Inr_in_univ = result();

val prems = goal Univ.thy "[| B<=univ(A);  C<=univ(A) |] ==> B+C <= univ(A)";
by (rtac (plus_mono RS subset_trans) 1);
by (REPEAT (ares_tac (prems@[subsetI,Inl_in_univ,Inr_in_univ]) 1
     ORELSE eresolve_tac [plusE, ssubst] 1));
val plus_subset_univ = result();


(** Closure under union -- use Un_least **)

val prems = goal Univ.thy "[| B<=univ(A) |] ==> Collect(B,P) <= univ(A)";
by (rtac (subsetI RS subset_trans) 1);
by (etac CollectD1 1);
by (resolve_tac prems 1);
val Collect_subset_univ = result();


(** The natural numbers **)

val [major] = goal Univ.thy "m: nat ==> m<=nat_rec(m, A, %k r. r Un Pow(r))";
by (EVERY1 [ rtac (major RS nat_induct),
	     rtac empty_subsetI,
	     etac (nat_rec_succ_conv RS ssubst),
	     rtac succ_subsetI,
	     etac (PowI RS UnI2),
	     etac Un_upperbound1 ]);
val naturals_in_univ = result();

val prems = goalw Univ.thy [univ_def] "n:nat ==> n:univ(A)";
by (REPEAT (resolve_tac (prems@[nat_succ_I RS UN_I, PowI RS UnI2,
		 naturals_in_univ, nat_rec_succ_conv RS ssubst]) 1));
val nat_in_univ = result();

goal Univ.thy "nat <= univ(A)";
by (EVERY1 [ rtac subsetI, etac nat_in_univ ]);
val univ_nat_subset = result();

(** instances for 1 and 2 **)

goal Univ.thy "succ(0) : univ(A)";
by (REPEAT (ares_tac [nat_in_univ, nat_0_I, nat_succ_I] 1));
val one_in_univ = result();

goal Univ.thy "succ(succ(0)) : univ(A)";
by (REPEAT (ares_tac [nat_in_univ, nat_0_I, nat_succ_I] 1));
val two_in_univ = result();
