signature TYPE_EXT0 =
sig
  val typ_of_term: (string -> sort) * (string -> sort) -> term -> typ
end;

signature TYPE_EXT =
sig
  structure Extension:EXTENSION
  val constrain: string list * (sort -> string)option * term * typ -> term
  val tapplC: term
  val term_of_typ: string list * (sort -> string)option -> typ -> term
  val typesC: term
  val type_ext: Extension.ext
  include TYPE_EXT0
end;

functor TypeExtFun(structure Extension:EXTENSION and Lexicon:LEXICON)
	: TYPE_EXT =
struct

structure Extension = Extension;

local open Extension in

(* TRANSLATION BETWEEN TYPES AND THEIR TERM REPRESENTATION *)

val funS = "_=>_";
val funC = Const(funS,dummyT);

val tapplS = "_()type";
val tapplC = Const(tapplS,dummyT);

val typesS = "_,type";
val typesC = Const(typesS,dummyT);

fun typ0 S_of_s =
  let fun err(a) = error("Inconsistent sort constraints for type variable "^a)
      fun typ(t as Free(a,_),mm) =
	    (if Lexicon.is_identifier a then Type(a,[]) else TFree(a,any),mm)
	| typ(Var(v,_),mm) = (TVar(v,any),mm)
	| typ(Const("_of sort",_)$Free(a,_)$Free(s,_),(fm,vm)) =
	    let val S = S_of_s s and T = TFree(a,any)
	    in case assoc(fm,a) of
		 None => (T,((a,S)::fm,vm))
	       | Some(S') => if S=S' then (T,(fm,vm)) else err(a)
	    end
        | typ(Const("_of sort",_)$Var(v,_)$Free(s,_),(fm,vm)) =
	    let val S = S_of_s s and T = TVar(v,any)
	    in case assoc(vm,v) of
		 None => (T,(fm,(v,S)::vm))
	       | Some(S') => if S=S' then (T,(fm,vm))
			     else err(Lexicon.string_of_vname v)
	    end
	| typ(_$args$Free(a,_),mm) =
	    let val (Ts,mm') = typs(args,mm) in (Type(a,Ts), mm') end
      and typs(Const("_,type",_)$ty$tys,mm) =
	    let val (T,mm') = typ(ty,mm);
		val (Ts,mm'') = typs(tys,mm')
	    in (T::Ts,mm'') end
	| typs(x) = let val (T,mm) = typ(x) in ([T],mm) end
  in typ end;

fun typ_of_term (defaultS,S_of_s) t =
  let val (T0,(fm,vm)) = typ0 S_of_s (t,([],[]));
      fun vsort(v as (a,_)) =
	    case assoc(vm,v) of None => defaultS a | Some(S) => S;
      fun fsort(a) =
	    case assoc(fm,a) of None => defaultS a | Some(S) => S;
      fun addS(Type(a,Ts)) = Type(a, map addS Ts)
	| addS(TVar(v,_)) = TVar(v, vsort v)
	| addS(TFree(a,_)) = TFree(a, fsort a)
  in addS T0 end;


val ofsortC = Const("_of sort",dummyT);

fun term_of_typ (tmixfixs,opt) =
let fun sort(t,S) = case opt of None => t
		    | Some(s_of_S) => ofsortC $ t $ Free(s_of_S S,dummyT);
    fun typ(Type(a, [])) = Free(a,dummyT)
      | typ(Type(a, Ts)) =
	  if a mem tmixfixs then list_comb(Const(a,dummyT), map typ Ts)
	  else tapplC $ typs Ts $ Free(a,dummyT)
      | typ(TFree(a,S)) = sort(Free(a,dummyT),S)
      | typ(TVar(v,S)) = sort(Var(v,dummyT),S)
    and typs(T::Ts) = let val t = typ T
	in if Ts=[] then t else typesC $ t $ typs(Ts) end
in typ end;

fun constrain(fixs,opt,t,T) =
    Const(constrainC,dummyT)$ t $ term_of_typ(fixs,opt) T;

val TYPES = "TYPES";
val types = Type(TYPES,[]);

fun fun_tr[t1,t2] = tapplC$(typesC$t1$t2)$Free("fun",dummyT);

fun fun_tr'[_$t1$t2, Free("fun",_)] = funC$t1$t2;

fun bracket_tr[dom,cod] =
let fun tr(Const("_,type",_)$T$Ts) = fun_tr[T,tr Ts]
      | tr(T) = fun_tr[T,cod]
in tr dom end;

val type_ext = Ext{roots = [Extension.ANY,"TYPE"],
mfix=
[(* meta-types: *)
 Mfix("_", tfreeT --> typeT, "",[],max_pri),
 Mfix("_", tvarT  --> typeT, "",[],max_pri),
 Mfix("_", idT    --> typeT, "",[],max_pri),
 Mfix("_::_", [tfreeT,idT] ---> typeT, "_of sort",[max_pri,0],max_pri),
 Mfix("_::_", [tvarT,idT]  ---> typeT, "_of sort",[max_pri,0],max_pri),
 Mfix("_/ _", [typeT,idT] ---> typeT, tapplS, [max_pri,0], max_pri),
 Mfix("((1'(_'))/_)", [types,idT] ---> typeT, tapplS,[],max_pri),
 Mfix("_", typeT --> types, "",[],max_pri),
 Mfix("_,/_", [typeT,types] ---> types, typesS,[],max_pri),
 Mfix("_ => _", [typeT,typeT] ---> typeT, funS, [1,0], 0),
 (* an abbriviation: *)
 Mfix("[_] => _", [types,typeT] ---> typeT, "_[]=>", [0,0], 0)
],

parse_translation = [(funS,fun_tr), ("_[]=>",bracket_tr)],
print_translation = [(tapplS,fun_tr')],
tmixfixs = []
};

end;

end;
