(*  Title: 	LCF/ex.ML
    Author: 	Tobias Nipkow
    Copyright   1991  University of Cambridge

Some examples from Lawrence Paulson's book Logic and Computation.
*)


(***  Section 10.4  ***)

val ex_thy = extend_theory thy "Ex 10.4"
([], [], [],
 [(["P"], "'a => tr"),
  (["G","H"], "'a => 'a"),
  (["K"], "('a => 'a) => ('a => 'a)")
 ],
 None)
[ ("P_strict", "P(UU) = UU"),
  ("K", "K = (%h x. P(x) => x | h(h(G(x))))"),
  ("H", "H = FIX(K)")
];
val ax = get_axiom ex_thy;

val P_strict = ax"P_strict";
val K = ax"K";
val H = ax"H";

val ex_ss = LCF_ss addcongs (mk_congs ex_thy ["P","G","H","K"])
		   addrews [P_strict,K];


val H_unfold = prove_goal ex_thy "H = K(H)"
 (fn _ => [stac H 1, rtac (FIX_eq RS sym) 1]);

val H_strict = prove_goal ex_thy "H(UU)=UU"
 (fn _ => [stac H_unfold 1, SIMP_TAC ex_ss 1]);

val ex_ss = ex_ss addrews [H_strict];

goal ex_thy "ALL x. H(FIX(K,x)) = FIX(K,x)";
by(induct_tac "K" 1);
by(SIMP_TAC ex_ss 1);
by(SIMP_CASE_TAC ex_ss  1);
by(strip_tac 1);
by(stac H_unfold 1);
by(ASM_SIMP_TAC ex_ss 1);
val H_idemp_lemma = topthm();

local val ss = LCF_ss addcongs (mk_congs ex_thy ["H"]) addrews [H RS sym]
in val H_idemp = SIMP_THM ss H_idemp_lemma end;


(***  Example 3.8  ***)

val ex_thy = extend_theory thy "Ex 3.8"
([], [], [],
 [(["P"], "'a => tr"),
  (["F","G"], "'a => 'a"),
  (["H"], "'a => 'b => 'b"),
  (["K"], "('a => 'b => 'b) => ('a => 'b => 'b)")
 ],
 None)
[ ("F_strict", "F(UU) = UU"),
  ("K", "K = (%h x y. P(x) => y | F(h(G(x),y)))"),
  ("H", "H = FIX(K)")
];
val ax = get_axiom ex_thy;

val F_strict = ax"F_strict";
val K = ax"K";
val H = ax"H";

val ex_ss = LCF_ss addcongs (mk_congs ex_thy ["F","G","H","K"])
		   addrews [F_strict,K];

goal ex_thy "ALL x. F(H(x::'a,y::'b)) = H(x,F(y))";
by(stac H 1);
by(induct_tac "K::('a=>'b=>'b)=>('a=>'b=>'b)" 1);
by(SIMP_TAC ex_ss 1);
by(ASM_SIMP_CASE_TAC ex_ss  1);
result();


(*** Addition with fixpoint of successor ***)

val ex_thy = extend_theory thy "fix ex"
([], [], [],
 [(["s"], "'a => 'a"),
  (["p"], "'a => 'a => 'a")
 ],
 None)
[ ("p_strict", "p(UU) = UU"),
  ("p_s", "p(s(x),y) = s(p(x,y))")
];
val ax = get_axiom ex_thy;

val p_strict = ax"p_strict";
val p_s = ax"p_s";

val ex_ss = LCF_ss addcongs (mk_congs ex_thy ["s","p"])
		   addrews [p_strict,p_s];

goal ex_thy "p(FIX(s),y) = FIX(s)";
by(induct_tac "s" 1);
by(SIMP_TAC ex_ss 1);
by(SIMP_TAC ex_ss 1);
result();


(*** Prefixpoints ***)

val asms = goal thy "[| f(p) << p; !!q. f(q) << q ==> p << q |] ==> FIX(f)=p";
by(rewrite_goals_tac [eq_def]);
br conjI 1;
by(induct_tac "f" 1);
br minimal 1;
by(strip_tac 1);
br less_trans 1;
brs asms 2;
be less_ap_term 1;
brs asms 1;
br (FIX_eq RS eq_imp_less1) 1;
result();

maketest();    (*Record successful termination*)
writeln"END: file for LCF examples";
