(*  Title: 	HOL/fun
    Author: 	Tobias Nipkow, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Some simple lemmas about functions.
*)

goal Class.thy "(f = g) = (!x. f(x)=g(x))";
by (rtac iffI 1);
by (REPEAT (ASM_SIMP_TAC HOL_ss 1));
val expand_fun_eq = result();

val prems = goal Class.thy
    "[| f(x)=u;  !!x. P(x) ==> g(f(x)) = x;  P(x) |] ==> x=g(u)";
br (ap_term RS box_equals) 1;
by (REPEAT (resolve_tac (prems@[refl]) 1));
val apply_inverse = result();


(*** One_One(f): f is a one-to-one function ***)

val prems = goalw Class.thy [One_One_def]
    "[| !! x y. f(x) = f(y) ==> x=y |] ==> One_One(f)";
by (fast_tac (HOL_cs addIs prems) 1);
val One_OneI = result();

val [major] = goal Class.thy "(!!x. g(f(x)) = x) ==> One_One(f)";
br One_OneI 1;
be (ap_term RS box_equals) 1;
br major 1;
br major 1;
val One_One_inverseI = result();

val [major,minor] = goalw Class.thy [One_One_def]
    "[| One_One(f); f(x) = f(y) |] ==> x=y";
by (cut_facts_tac [major] 1);
by (fast_tac (HOL_cs addIs [minor]) 1);
val One_OneD = result();

val [major] = goal Class.thy "One_One(f) ==> (@x.f(x)=f(y)) = y";
br (major RS One_OneD) 1;
br selectI 1;
br refl 1;
val One_One_select = result();

(*A one-to-one function has an inverse (given using select).*)
val [major] = goal Class.thy "One_One(f) ==> Inv(f,f(x)) = x";
by (EVERY1 [stac Inv_def, rtac (major RS One_One_select)]);
val Inv_f_f = result();

(* Useful??? *)
val [oneone,minor] = goal Class.thy
    "[| One_One(f); !!y. y: range(f) ==> P(Inv(f,y)) |] ==> P(x)";
by (res_inst_tac [("t", "x")] (oneone RS (Inv_f_f RS subst)) 1);
br (rangeI RS minor) 1;
val One_One_transfer = result();


(*** One_One_on(f,A): f is one-to-one over A ***)

val prems = goalw Class.thy [One_One_on_def]
    "(!! x y. [| f(x) = f(y); x:A; y:A |] ==> x=y) ==> One_One_on(f,A)";
by (fast_tac (HOL_cs addIs prems) 1);
val One_One_onI = result();

val [major] = goal Class.thy 
    "(!!x. x:A ==> g(f(x)) = x) ==> One_One_on(f,A)";
br One_One_onI 1;
be (apply_inverse RS trans) 1;
by (REPEAT (eresolve_tac [asm_rl,major] 1));
val One_One_on_inverseI = result();

val major::prems = goalw Class.thy [One_One_on_def]
    "[| One_One_on(f,A);  f(x)=f(y);  x:A;  y:A |] ==> x=y";
by (cut_facts_tac [major] 1);
by (fast_tac (HOL_cs addIs prems) 1);
val One_One_onD = result();

val major::prems = goal Class.thy
    "[| One_One_on(f,A);  ~x=y;  x:A;  y:A |] ==> ~ f(x)=f(y)";
br contrapos 1;
be (major RS One_One_onD) 2;
by (REPEAT (resolve_tac prems 1));
val One_One_on_contraD = result();


(*** Lemmas about One_One ***)

val prems = goal Class.thy
    "[| One_One(f);  One_One_on(g,range(f)) |] ==> One_One(g o f)";
by (stac o_def 1);
by (cut_facts_tac prems 1);
by (fast_tac (HOL_cs addIs [One_OneI,rangeI]
                     addEs [One_OneD,One_One_onD]) 1);
val comp_One_One = result();

val [prem] = goal Class.thy "One_One(f) ==> One_One_on(f,A)";
by (fast_tac (HOL_cs addIs [prem RS One_OneD, One_One_onI]) 1);
val One_One_imp = result();

val [prem] = goal Class.thy "y : range(f) ==> f(Inv(f,y)) = y";
by (EVERY1 [stac Inv_def, rtac (prem RS rangeE), rtac selectI, etac sym]);
val f_Inv_f = result();

val prems = goal Class.thy
    "[| Inv(f,x)=Inv(f,y); x: range(f);  y: range(f) |] ==> x=y";
br (ap_term RS box_equals) 1;
by (REPEAT (resolve_tac (prems @ [f_Inv_f]) 1));
val Inv_injective = result();

val prems = goal Class.thy
    "[| One_One(f);  A<=range(f) |] ==> One_One_on(Inv(f), A)";
by (cut_facts_tac prems 1);
by (fast_tac (HOL_cs addIs [One_One_onI] 
		     addEs [Inv_injective,One_OneD,subsetD]) 1);
val One_One_on_Inv = result();

