(*  Title: 	HOL/ROOT
    Author: 	Tobias Nipkow
    Copyright   1990  University of Cambridge

Adds Classical Higher-order Logic to a database containing pure Isabelle. 
Should be executed in the subdirectory HOL.

Reorder parameters in wf.ML?
ex/prop-log: construct the type of propositions and define logic using lfp?
*)

writeln"Root file for Classical Higher-order Logic";

print_depth 1;  
use ".rules.ML";
use "lemmas.ML";
use "../Provers/hypsubst.ML";
use "../Provers/classical.ML";
use "../Provers/simp.ML";
use "../Provers/ind.ML";

structure HOL_Rule = HOL_RuleFun();
structure HOL_Lemmas = HOL_LemmasFun(HOL_Rule);

open Syntax HOL_Rule HOL_Lemmas;

(** Applying HypsubstFun to generate hyp_subst_tac **)

structure Hypsubst_Data =
  struct
  (*Take apart an equality judgement; otherwise raise Match!*)
  fun dest_eq (Const("Trueprop",_) $ (Const("op =",_)  $ t $ u)) = (t,u);

  val imp_intr = impI

  (*etac rev_cut_eq moves an equality to be the last premise. *)
  val rev_cut_eq = prove_goal HOL_Rule.thy "[| a=b;  a=b ==> R |] ==> R"
   (fn prems => [ REPEAT(resolve_tac prems 1) ]);

  val rev_mp = rev_mp
  val subst = subst 
  val sym = sym
  end;

structure Hypsubst = HypsubstFun(Hypsubst_Data);
open Hypsubst;

(** Applying ClassicalFun to create a classical prover **)
structure Classical_Data = 
  struct
  val size_of_thm = size_of_thm
  val imp_elim = impE
  val not_elim = notE
  val swap = swap
  val hyp_subst_tacs=[hyp_subst_tac]
  end;

structure Classical = ClassicalFun(Classical_Data);
open Classical;

(*Propositional rules*)
val prop_cs = empty_cs addSIs [TrueI,conjI,disjCI,impI,notI,iffI] addIs [refl] 
                       addSEs [conjE,disjE,impCE,FalseE,iffE];

(*Quantifier rules*)
val HOL_cs = prop_cs addSIs [allI] addIs [exI,ex1I] addXIs [exCI] 
                     addSEs [exE,ex1E] addEs [allE];

structure HOL_Induction = InductionFun(struct val spec=spec end);
open HOL_Induction;

use"simpdata.ML";
use"class.ML";
use"fun.ML";
use"subset.ML";
use"equalities.ML";
use"prod.ML";
use"sum.ML";
use"wf.ML";
use"mono.ML";
use"fixedpt.ML";
use"trancl.ML";
use"nat.ML";
use"sexp.ML";
use"univ.ML";
use"list.ML";

(* Set up automatic printing of theorems -- works in Poly/ML only *)
install_pp (fn _=> print_thm);
print_depth 8;  

