(*  Title: 	ZF/func
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Functions in Zermelo-Fraenkel Set Theory
*)

(*** The Pi operator -- dependent function space ***)

val prems = goalw set_thy [Pi_def]
    "[| f <= Sigma(A,B);  !!x. x:A ==> EX! y. <x,y>: f |] ==> \
\     f: Pi(A,B)";  
by (REPEAT (ares_tac (prems @ [CollectI,PowI,ballI,impI]) 1));
val PiI = result();

(**Two "destruct" rules for Pi*)
val major::prems = goalw set_thy [Pi_def]
    "f: Pi(A,B) ==> f <= Sigma(A,B)";  
br (major RS CollectE) 1;
be PowD 1;
val fun_is_rel = result();

val major::prems = goalw set_thy [Pi_def]
    "[| f: Pi(A,B);  a:A |] ==> EX! y. <a,y>: f";  
br (major RS CollectE) 1;
be bspec 1;
brs prems 1;
val fun_unique_Pair = result();

val prems = goal set_thy
    "[| f: Pi(A,B); \
\       [| f <= Sigma(A,B);  ALL x:A. EX! y. <x,y>: f |] ==> P \
\    |] ==> P";  
by (REPEAT (ares_tac (prems@[ballI,fun_is_rel,fun_unique_Pair]) 1));
val PiE = result();

val prems = goalw set_thy [Pi_def]
    "[| A=A';  !!x. x:A' ==> B(x)=B'(x) |] ==> Pi(A,B) = Pi(A',B')";
by (prove_cong_tac (prems@[Collect_cong,Sigma_cong,ball_cong]) 1);
val Pi_cong = result();

(*** Function Application ***)

val prems = goalw set_thy [apply_def]
    "[| <a,b>: f;  f: Pi(A,B) |] ==> f`a = b";
by (cut_facts_tac prems 1);
by (REPEAT (eresolve_tac [asm_rl,PiE,SigmaE2] 1
     ORELSE ball_tac 1 ORELSE set_mp_tac 1
     ORELSE rtac the_equality 1));
by (etac ex1E 1);
(*both <a,y>:f and <a,ya>:f therefore y=b*)
br trans 1;
br sym 2;
by (REPEAT (eresolve_tac [asm_rl,mp,allE] 1));
val apply_equality = result();

val prems = goal set_thy
    "[| f: Pi(A,B);  \
\       c: f;        \
\       !!x. [| x:A;  c = <x,f`x> |] ==> P \
\    |] ==> P";
by (cut_facts_tac prems 1);
be (fun_is_rel RS subsetD RS SigmaE) 1;
by (REPEAT (ares_tac prems 1));
by (hyp_subst_tac 1);
be (apply_equality RS ssubst) 1;
brs prems 1;
br refl 1;
val memberPiE = result();

val prems = goal set_thy
    "[| <a,b>: f;  <a,c>: f;  f: Pi(A,B) |] ==> b=c";
by (cut_facts_tac prems 1);
by (REPEAT (ares_tac [refl] 1  
     ORELSE eresolve_tac [apply_equality RS subst] 1));
val apply_equality2 = result();

(*Should there be a special version for A->B?  Conclusion is too flexible!*)
val prems = goal set_thy
    "[| f: Pi(A,B);  a:A |] ==> f`a : B(a)"; 
by (cut_facts_tac prems 1);
by (REPEAT (ball_tac 1 ORELSE set_mp_tac 1
     ORELSE eresolve_tac [PiE,SigmaE2,ex1E] 1));
by (eresolve_tac [apply_equality RS ssubst] 1);
by (REPEAT (ares_tac prems 1));
val apply_type = result();

val prems = goal set_thy "[| f: Pi(A,B);  a:A |] ==> <a,f`a>: f";
by (cut_facts_tac prems 1);
by (REPEAT (ball_tac 1 ORELSE eresolve_tac [PiE,ex1E] 1));
by (resolve_tac [apply_equality RS ssubst] 1);
by (REPEAT (ares_tac prems 1));
val apply_Pair = result();

val prems = goal set_thy
    "[| f: Pi(A,B);  a:A |] ==> <a,b>: f <-> f`a = b";
by (cut_facts_tac prems 1);
by (fast_tac (ZF_cs addIs [apply_Pair,apply_equality]) 1);
val apply_iff = result();

(*Refining a function type to a Pi type*)
val prems = goal set_thy
    "[| f: A->C;  !!x. x:A ==> f`x : B(x)   |] ==>  \
\    f : Pi(A,B)";
by (REPEAT (ares_tac (prems@[PiI,subsetI,SigmaI,fun_unique_Pair]) 1  
     ORELSE eresolve_tac ((prems RL [memberPiE]) @ [ssubst]) 1));
val Pi_type = result();


(** Elimination of membership in a function **)

val prems = goal set_thy
    "[| <a,b>: f;  f: Pi(A,B);       \
\       [| a:A;  b:B(a);  f`a = b |] ==> P  \
\    |] ==> P";
by (rtac (fun_is_rel RS subsetD RS SigmaE) 1);
by (REPEAT (ares_tac (prems@[apply_equality]) 1
     ORELSE eresolve_tac [Pair_inject,ssubst] 1));
val Pair_mem_PiE = result();

val prems = goal set_thy "[| <a,b> : f;  f: Pi(A,B) |] ==> a : A";
by (cut_facts_tac prems 1);
by (REPEAT (atac 1 ORELSE etac Pair_mem_PiE 1));
val domain_type = result();

val prems = goal set_thy "[| <a,b> : f;  f: Pi(A,B) |] ==> b : B(a)";
by (cut_facts_tac prems 1);
by (REPEAT (atac 1 ORELSE etac Pair_mem_PiE 1));
val range_type = result();

(*** Lambda Abstraction ***)

val prems = goalw set_thy [lam_def] "a:A ==> <a,b(a)> : (lam x:A. b(x))";  
by (REPEAT (ares_tac (prems @ [RepFunI,refl]) 1));
val lamI = result();

val major::prems = goalw set_thy [lam_def]
    "[| p: (lam x:A. b(x));  !!x.[| x:A; p=<x,b(x)> |] ==> P  \
\    |] ==>  P";  
by (rtac (major RS RepFunE) 1);
by (REPEAT (ares_tac prems 1));
val lamE = result();

val prems = goal set_thy "[| <a,c>: (lam x:A. b(x)) |] ==> c = b(a)";  
by (cut_facts_tac prems 1);
by (REPEAT (eresolve_tac [asm_rl,lamE,Pair_inject,ssubst] 1));
val lamD = result();

val prems = goal set_thy
    "[| !!x. x:A ==> b(x): B(x) |] ==> (lam x:A.b(x)) : Pi(A,B)";  
by (REPEAT (ares_tac (prems @ [PiI,ex1I,lamI,SigmaI,subsetI]) 1
     ORELSE eresolve_tac [lamE,Pair_inject,ssubst] 1));
val lam_type = result();

goal set_thy "(lam x:A.b(x)) :  A -> RepFun(A,b)";
by (REPEAT (ares_tac [refl,lam_type,RepFunI] 1));
val lam_funtype = result();

val prems = goal set_thy "a : A ==> (lam x:A.b(x)) ` a = b(a)";
by (REPEAT (resolve_tac (prems@[apply_equality,lam_funtype,lamI]) 1));
val beta_conv = result();

(*congruence rule for lambda abstraction*)
val prems = goal set_thy
    "[| A=A';  !!x. x:A' ==> b(x)=b'(x) |] ==>  \
\    (lam x:A.b(x)) = (lam x:A'.b'(x))";
bw lam_def;
by (REPEAT (ares_tac (prems@[refl, RepFun_cong]) 1
     ORELSE res_inst_tac [("t","Pair")] subst_context2 1));
val lam_cong = result();

val [major] = goal set_thy
    "(!!x. x:A ==> EX! y. Q(x,y)) ==> EX h. ALL x:A. Q(x, h`x)";
by (res_inst_tac [("x", "lam x: A. THE y. Q(x,y)")] exI 1);
br ballI 1;
br (beta_conv RS ssubst) 1;
ba 1;
be (major RS theI) 1;
val lam_theI = result();


(** Extensionality **)

(*Semi-extensionality!*)
val prems = goal set_thy
    "[| f : Pi(A,B);  g: Pi(C,D);  A<=C; \
\       !!x. x:A ==> f`x = g`x       |] ==> f<=g";
by (rtac subsetI 1);
by (eresolve_tac (prems RL [memberPiE]) 1);
by (etac ssubst 1);
by (resolve_tac (prems RL [ssubst]) 1);
by (REPEAT (ares_tac (prems@[apply_Pair,subsetD]) 1));
val fun_subset = result();

val prems = goal set_thy
    "[| f : Pi(A,B);  g: Pi(A,D);  !!x. x:A ==> f`x = g`x |] ==> f=g";
by (REPEAT (ares_tac (prems @ (prems RL [sym]) @
		      [subset_refl,equalityI,fun_subset]) 1));
val fun_extension = result();

val prems = goal set_thy
    "f : Pi(A,B) ==> (lam x:A. f`x) = f";
by (rtac fun_extension 1);
by (REPEAT (ares_tac (prems@[lam_type,apply_type,beta_conv]) 1));
val eta_conv = result();

(*Every element of Pi(A,B) may be expressed as a lambda abstraction!*)
val prems = goal set_thy
    "[| f: Pi(A,B);        \
\       !!b. [| ALL x:A. b(x):B(x);  f = (lam x:A.b(x)) |] ==> P   \
\    |] ==> P";
brs prems 1;
br (eta_conv RS sym) 2;
by (REPEAT (ares_tac (prems@[ballI,apply_type]) 1));
val Pi_lamE = result();


(*** properties of "restrict" ***)

val prems = goalw set_thy [restrict_def]
    "[| !!x. x:A ==> f`x: B(x) |] ==> restrict(f,A) : Pi(A,B)";  
br lam_type 1;
bes prems 1;
val restrict_type = result();

val prems = goalw set_thy [restrict_def] "a : A ==> restrict(f,A) ` a = f`a";
br beta_conv 1;
brs prems 1;
val restrict_conv = result();

(*NOT SAFE as a congruence rule for the simplifier!  Can cause it to fail!*)
val prems = goalw set_thy [restrict_def]
    "[| A=B;  !!x. x:B ==> f`x=g`x |] ==> restrict(f,A) = restrict(g,B)";
by (REPEAT (ares_tac (prems@[lam_cong]) 1));
val restrict_eqI = result();

goalw set_thy [restrict_def] "domain(restrict(f,C)) = C";
by (REPEAT (ares_tac [equalityI,subsetI,domainI,lamI] 1
     ORELSE eresolve_tac [domainE,lamE,Pair_inject,ssubst] 1));
val domain_restrict = result();

(*** Unions of functions ***)

(** The Union of a set of COMPATIBLE functions is a function **)
val [ex_prem,disj_prem] = goal set_thy
    "[| !!x. x:S ==> EX C D. x:C->D; \
\       !!x y. [| x:S;  y:S |] ==> x<=y | y<=x  |] ==>  \
\    Union(S) : domain(Union(S)) -> range(Union(S))";
val premE = ex_prem RS exE;
by (REPEAT (eresolve_tac [exE,PiE,premE] 1 
     ORELSE ares_tac [PiI,rel_Union,exI] 1));
by (REPEAT (eresolve_tac [asm_rl,domainE,UnionE,exE] 1 
     ORELSE ares_tac [allI,impI,ex1I,UnionI] 1));
by (res_inst_tac [ ("x1","B") ] premE 1);
by (res_inst_tac [ ("x1","Ba") ] premE 2);
by (REPEAT (eresolve_tac [asm_rl,exE] 1));
by (eresolve_tac [disj_prem RS disjE] 1);
by (DEPTH_SOLVE (set_mp_tac 1
		 ORELSE eresolve_tac [asm_rl, apply_equality2] 1));
val fun_Union = result();


(** The Union of 2 disjoint functions is a function **)

val prems = goal set_thy
    "[| f: A->B;  g: C->D;  A Int C = 0  |] ==>  \
\    (f Un g) : (A Un C) -> (B Un D)";
     (*Contradiction if A Int C = 0, a:A, a:B*)
val [disjoint] = prems RL ([IntI] RLN (2, [equals0D]));
by (cut_facts_tac prems 1);
by (rtac PiI 1);
(*solve subgoal 2 first!!*)
by (DEPTH_SOLVE_1 (eresolve_tac [UnE, Pair_mem_PiE, sym, disjoint] 2
       INTLEAVE ares_tac [ex1I, apply_Pair RS UnI1, apply_Pair RS UnI2] 2));
by (REPEAT (eresolve_tac [asm_rl,UnE,rel_Un,PiE] 1));
val fun_disjoint_Un = result();

val prems = goal set_thy
    "[| a:A;  f: A->B;  g: C->D;  A Int C = 0 |] ==>  \
\    (f Un g)`a = f`a";
by (REPEAT (ares_tac (prems@[apply_equality,UnI1,apply_Pair,
			     fun_disjoint_Un]) 1));
val fun_disjoint_apply1 = result();

val prems = goal set_thy
    "[| c:C;  f: A->B;  g: C->D;  A Int C = 0 |] ==>  \
\    (f Un g)`c = g`c";
by (REPEAT (ares_tac (prems@[apply_equality,UnI2,apply_Pair,
			     fun_disjoint_Un]) 1));
val fun_disjoint_apply2 = result();

(** Domain and range of a function/relation **)

val prems = goal set_thy "r <= Sigma(A,B) ==> r <= domain(r)*range(r)";
by (cut_facts_tac prems 1);
by (rtac subsetI 1);
by (eresolve_tac [subsetD RS SigmaE] 1);
by (assume_tac 1);
by (hyp_subst_tac 1);
by (REPEAT (ares_tac [SigmaI,domainI,rangeI] 1));
val domain_times_range = result();

val prems = goal set_thy "f : Pi(A,B) ==> domain(f)=A";
by (cut_facts_tac prems 1);
by (REPEAT (ares_tac [equalityI,subsetI,domainI,apply_Pair] 1
     ORELSE set_mp_tac 1
     ORELSE eresolve_tac [PiE,domainE,SigmaE2] 1));
val domain_of_fun = result();

val [major] = goal set_thy "f : Pi(A,B) ==> f : A->range(f)";
by (EVERY1 [cut_facts_tac [major],
	    etac PiE,
	    rtac PiI,
	    rtac (major RS (domain_of_fun RS subst)),
	    etac domain_times_range,
	    etac bspec,
	    assume_tac]);
val range_of_fun = result();

(*** Extensions of functions ***)

(*Singleton function -- in the underlying form of singletons*)
goal set_thy "Upair(<a,b>,<a,b>) : Upair(a,a) -> Upair(b,b)";
by (REPEAT (eresolve_tac [asm_rl,UpairE,Pair_inject,ssubst] 1  
     ORELSE ares_tac [PiI,subsetI,SigmaI,UpairI1,ex1I] 1));
val fun_single_lemma = result();

val prems = goalw set_thy [cons_def]
    "[| f: A->B;  c:A==>False \
\    |]  ==> cons(<c,b>,f) : cons(c,A) -> cons(b,B)";
by (REPEAT (ares_tac (prems@[fun_disjoint_Un,fun_single_lemma,equals0I]) 1  
	    
     ORELSE eresolve_tac [IntE, UpairE, subst] 1));
val fun_extend = result();

val prems = goal set_thy
    "[| f: A->B;  a:A;  c:A==>False  |] ==>  \
\    cons(<c,b>,f)`a = f`a";
by (REPEAT (ares_tac (prems@[apply_equality,consI2,apply_Pair,
			     fun_extend]) 1));
val fun_extend_apply1 = result();

val prems = goal set_thy
    "[| f: A->B;  c:A==>False  |] ==>  \
\    cons(<c,b>,f)`c = b";
by (REPEAT (ares_tac (prems@[apply_equality,consI1,apply_Pair,fun_extend]) 1));
val fun_extend_apply2 = result();

(*The empty function*)
goal set_thy "0: 0->0";
by (REPEAT (ares_tac [PiI,subsetI,SigmaI,ex1I] 1 
     ORELSE etac emptyE 1));
val fun_empty = result();

(*The singleton function*)
goal set_thy "{<a,b>} : {a} -> {b}";
by (REPEAT (ares_tac [fun_extend,fun_empty] 1 
     ORELSE etac emptyE 1));
val fun_single = result();

