(*  Title: 	ZF/plus
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Disjoint unions in Zermelo-Fraenkel Set Theory 
*)

writeln"File ZF/ex/plus";

val plus_mixfix = 
    [ Infixr("+","[i,i]=>i",65) ];

val plus_sext = Sext{mixfix		= plus_mixfix,
                     parse_translation	= [],
                     print_translation	= []};

val plus_const_decs =
    [ (["Inl","Inr"],	"i=>i"),
      (["when"],	"[i,i=>i,i=>i]=>i") ];

val plus_thy = extend_theory perm_thy "plus"
     ([], [], [], plus_const_decs, Some plus_sext)
  [ 
    ("plus_def",	"A+B == {0}*A Un {{0}}*B"),
    ("Inl_def",		"Inl(a) == < 0 ,a>"),
    ("Inr_def",		"Inr(b) == <{0},b>"),
    ("when_def",	
     "when(u,c,d) == THE y. EX z.(u=Inl(z) & y=c(z)) | (u=Inr(z) & y=d(z))")
  ];

local val ax = get_axiom plus_thy
in val plus_def 	= ax"plus_def";
   val Inl_def		= ax"Inl_def";
   val Inr_def		= ax"Inr_def";
   val when_def 	= ax"when_def";
end;

val plus_defs = [plus_def,Inl_def,Inr_def,when_def];


(* constructors *)

val prems = goalw plus_thy plus_defs "a : A ==> Inl(a) : A+B";
by (REPEAT (resolve_tac (prems @ [UnI1,SigmaI,singletonI]) 1));
val plus_InlI = result();

val prems = goalw plus_thy plus_defs "b : B ==> Inr(b) : A+B";
by (REPEAT (resolve_tac (prems @ [UnI2,SigmaI,singletonI]) 1));
val plus_InrI = result();

(* Injection rules *)

val [major] = goalw plus_thy plus_defs "Inl(a) = Inl(b) ==>  a=b";
by (EVERY1 [rtac (major RS Pair_inject), atac]);
val Inl_inject = result();

val [major] = goalw plus_thy plus_defs "Inr(a) = Inr(b) ==> a=b";
by (EVERY1 [rtac (major RS Pair_inject), atac]);
val Inr_inject = result();

val [major] = goalw plus_thy plus_defs "Inl(a)=Inr(b) ==> P";
by (rtac (major RS Pair_inject) 1);
by (etac (equalityD2 RS subsetD RS emptyE) 1);
by (rtac consI1 1);
val Inl_neq_Inr = result();

val prems = goalw plus_thy plus_defs
    "[| u: A+B;  \
\       !!x. x:A ==> P(Inl(x)); \
\       !!y. y:B ==> P(Inr(y)) \
\    |] ==> P(u)";
by (cut_facts_tac prems 1);
by (REPEAT (eresolve_tac [UnE,SigmaE,singletonE,ssubst] 1
     ORELSE ares_tac prems 1));
val plusE = result();

val [major] = goal plus_thy
    "u: A+B ==> (EX x. x:A & u=Inl(x)) | (EX y. y:B & u=Inr(y))";
by (rtac (major RS plusE) 1);
by (fast_tac ZF_cs 1);
by (fast_tac ZF_cs 1);
val plusE2 = result();


(*** Eliminator -- when ***)

goalw plus_thy [when_def] "when(Inl(a),c,d) = c(a)";
by (fast_tac (ZF_cs addIs [the_equality] 
		    addEs [make_elim Inl_inject, Inl_neq_Inr]) 1);
val when_Inl_conv = result();

goalw plus_thy [when_def] "when(Inr(b),c,d) = d(b)";
by (fast_tac (ZF_cs addIs [the_equality] 
		    addEs [make_elim Inr_inject, sym RS Inl_neq_Inr]) 1);
val when_Inr_conv = result();

val major::prems = goal plus_thy
    "[| u: A+B; \
\       !!x. x: A ==> c(x): C(Inl(x));   \
\       !!y. y: B ==> d(y): C(Inr(y)) \
\    |] ==> when(u,c,d) : C(u)";
by (rtac (major RS plusE) 1);
by (REPEAT (resolve_tac [when_Inl_conv RS ssubst, when_Inr_conv RS ssubst] 1
       THEN eresolve_tac prems 1));
val when_type = result();


val symtrans = sym RSN (2, trans RS sym);
val whenths =   ([when_Inl_conv,when_Inr_conv] RL [trans])
              @ ([when_Inl_conv,when_Inr_conv] RL [symtrans]);

val prems = goalw plus_thy [when_def]
    "[| u=u'; !!x. c(x)=c'(x);  !!y. d(y)=d'(y)    \
\    |] ==> when(u,c,d)=when(u',c',d')";
by (rtac the_cong 1);
by (rtac ex_cong 1);
by (EVERY1 (map rtac ((prems RL [ssubst]) @ [iff_refl])));
val when_cong = result();

val prems = goal plus_thy
    "[| u: A+B; \
\       u=u'; \
\       !!x. x: A ==> c(x)=c'(x);   \
\       !!y. y: B ==> d(y)=d'(y)    \
\    |] ==> when(u,c,d)=when(u',c',d')";
by (cut_facts_tac prems 1);
by (etac subst 1);
by (etac plusE 1);
by (REPEAT (ares_tac (prems@whenths) 1));
val when_cong_typed = result();

val prems = goalw plus_thy plus_defs "[| A<=C;  B<=D |] ==> A+B <= C+D";
by (REPEAT (resolve_tac (prems@[subset_refl,Un_mono,Sigma_mono]) 1));
val plus_mono = result();
