(*  Title: 	ZF/ex/mono
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Monotonicity of various operations (for lattice properties, see subset.ML)
*)

writeln"File ZF/ex/mono";

val prems = goal set_thy "A<=B ==> Collect(A,P) <= Collect(B,P)";
by (cfast_tac prems 1);
val Collect_mono = result();

(** Replacement, in its various formulations **)

val prems = goal set_thy "A<=B ==> Replace(A,P) <= Replace(B,P)";
by (cfast_tac prems 1);
val Replace_mono = result();

val prems = goal set_thy "A<=B ==> RepFun(A,f) <= RepFun(B,f)";
by (cfast_tac prems 1);
val RepFun_mono = result();

val prems = goal set_thy "A<=B ==> Pow(A) <= Pow(B)";
by (cfast_tac prems 1);
val Pow_mono = result();

val prems = goal set_thy "A<=B ==> Union(A) <= Union(B)";
by (cfast_tac prems 1);
val Union_mono = result();

val prems = goal set_thy
    "[| A<=B;  !!x. x:A ==> f(x)<=g(x) \
\    |] ==> Union(RepFun(A,f)) <= Union(RepFun(B,g))";
by (fast_tac (ZF_cs addIs (prems RL [subsetD])) 1);
val UN_mono = result();

(*Intersection is ANTI-monotonic.  There are TWO premises! *)
val prems = goal set_thy "[| A<=B;  a:A |] ==> Inter(B) <= Inter(A)";
by (cfast_tac prems 1);
val Inter_anti_mono = result();

val prems = goal set_thy "[| C<=D |] ==> cons(a,C) <= cons(a,D)";
by (fast_tac (ZF_cs addIs (prems RL [subsetD])) 1);
val cons_mono = result();

val prems = goal set_thy "[| A<=C;  B<=D |] ==> A Un B <= C Un D";
by (cfast_tac prems 1);
val Un_mono = result();

val prems = goal set_thy "[| A<=C;  B<=D |] ==> A Int B <= C Int D";
by (cfast_tac prems 1);
val Int_mono = result();

val prems = goal set_thy "[| A<=C;  D<=B |] ==> A-B <= C-D";
by (cfast_tac prems 1);
val Diff_mono = result();

val prems = goal set_thy "[| A<=C;  B<=D |] ==> A*B <= C*D";
by (cfast_tac prems 1);
val Sigma_mono = result();
val product_mono = Sigma_mono;

(*Note that B->A and C->A are typically disjoint!*)
val prems = goal set_thy "[| B<=C |] ==> A->B <= A->C";
by (fast_tac (ZF_cs addIs ([lam_type] @ (prems RL [subsetD]))
     		    addEs [Pi_lamE]) 1);
val Pi_mono = result();

(** Domain, range, field **)

val prems = goal set_thy "[| r<=s |] ==> domain(r)<=domain(s)";
by (cfast_tac prems 1);
val domain_mono = result();

val [prem] = goal set_thy "r <= Sigma(A,B) ==> domain(r) <= A";
by (rtac (domain_subset RS (prem RS domain_mono RS subset_trans)) 1);
val domain_rel_subset = result();

val prems = goal set_thy "[| r<=s |] ==> range(r)<=range(s)";
by (cfast_tac prems 1);
val range_mono = result();

val [prem] = goal set_thy "r <= A*B ==> range(r) <= B";
by (rtac (range_subset RS (prem RS range_mono RS subset_trans)) 1);
val range_rel_subset = result();

val prems = goal set_thy "[| r<=s |] ==> field(r)<=field(s)";
by (cfast_tac prems 1);
val field_mono = result();

val [prem] = goal set_thy "r <= A*A ==> field(r) <= A";
by (rtac (field_subset RS (prem RS field_mono RS subset_trans)) 1);
val field_rel_subset = result();


(** Images **)

val prems = goal set_thy "[| r<=s;  A<=B |] ==> r``A <= s``B";
by (cfast_tac prems 1);
val image_mono = result();

val prems = goal set_thy "[| r<=s;  A<=B |] ==> r-``A <= s-``B";
by (cfast_tac prems 1);
val vimage_mono = result();

