(*  Title: 	ZF/ex/equalities
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Set Theory examples: Union, Intersection, Inclusion, etc.
    (Thanks to Philippe de Groote.)
*)

writeln"File ZF/ex/equalities";

(** Absorptive laws of Int and Un **)

val eq_cs = ZF_cs addIs [equalityI];

goal set_thy "A Int A = A";
by (fast_tac eq_cs 1);
val Int_absorb = result();

goal set_thy "A Un A = A";
by (fast_tac eq_cs 1);
val Un_absorb = result();

val prems = goal set_thy "A<=B ==> A Un B = B";
by (cut_facts_tac prems 1);
by (fast_tac eq_cs 1);
val Un_absorb_subsetI = result();

val prems = goal set_thy "A Un B = B  ==>  A<=B";
by (cfast_tac prems 1);
val Un_absorb_subsetD = result();

val prems = goal set_thy "A<=B ==> A Int B = A";
by (cut_facts_tac prems 1);
by (fast_tac eq_cs 1);
val Int_absorb_subsetI = result();

val prems = goal set_thy "A Int B = A  ==>  A<=B";
by (cfast_tac prems 1);
val Int_absorb_subsetD = result();

(** Simple properties of Diff -- set difference **)

goal set_thy "A-A = 0";
by (fast_tac eq_cs 1);
val Diff_cancel = result();

goal set_thy "A Int (B-A) = 0";
by (fast_tac eq_cs 1);
val Diff_disjoint = result();

val prems = goal set_thy
    "A<=B ==> A Un (B-A) = B";
by (cut_facts_tac prems 1);
by (fast_tac eq_cs 1);
val Diff_partition = result();

val prems = goal set_thy
    "[| A<=B; B<= C |] ==> (B - (C-A)) = A";
by (cut_facts_tac prems 1);
by (fast_tac eq_cs 1);
val double_complement = result();

(** Commutative laws of Int and Un **)

goal set_thy "A Int B  =  B Int A";
by (fast_tac eq_cs 1);
val Int_commute = result();

goal set_thy "A Un B  =  B Un A";
by (fast_tac eq_cs 1);
val Un_commute = result();

(** Associative laws of Int and Un **)

goal set_thy "(A Int B) Int C  =  A Int (B Int C)";
by (fast_tac eq_cs 1);
val Int_assoc = result();

goal set_thy "(A Un B) Un C  =  A Un (B Un C)";
by (fast_tac eq_cs 1);
val Un_assoc = result();


(** Distributive laws of Int and Un **)

goal set_thy "(A Int B) Un C  =  (A Un C) Int (B Un C)";
by (fast_tac eq_cs 1);
val Un_Int_distrib = result();

goal set_thy "(A Un B) Int C  =  (A Int C) Un (B Int C)";
by (fast_tac eq_cs 1);
val Int_Un_distrib = result();

goal set_thy
 "(A Int B) Un (B Int C) Un (C Int A) = (A Un B) Int (B Un C) Int (C Un A)";
by (fast_tac eq_cs 1);
val Int_Un_crazy = result();

goal set_thy "A - (B Un C) = (A-B) Int (A-C)";
by (fast_tac eq_cs 1);
val DiffUn = result();

goal set_thy "A - (B Int C) = (A-B) Un (A-C)";
by (fast_tac eq_cs 1);
val DiffInt = result();


(*Both directions of Halmos, Naive Set Theory, page 16.*)

val prems = goal set_thy "C<=A ==> (A Int B) Un C = A Int (B Un C)";
by (cut_facts_tac prems 1);
by (fast_tac eq_cs 1);
val Int_Un_assocI = result();

val [prem] = goal set_thy "(A Int B) Un C = A Int (B Un C)  ==>  C<=A";
by (rtac (prem RS equalityE) 1);
by (fast_tac eq_cs 1);
val Int_Un_assocD = result();


(** Big Union and Intersection **)

goal set_thy "Union(A Un B) = Union(A) Un Union(B)";
by (fast_tac eq_cs 1);
val Union_Un_distrib = result();

val [prem] = goal set_thy
   "(!!B. B:C ==> B Int A = 0)  ==>  Union(C) Int A = 0";
by (fast_tac (eq_cs addEs [prem RS equals0D]) 1);
val Union_disjointI = result();

val prems = goal set_thy
   "[| Union(C) Int A = 0;  B:C |] ==> B Int A = 0";
by (cut_facts_tac prems 1);
by (etac equalityE 1);
by (fast_tac eq_cs 1);
val Union_disjointD = result();

(* A good challenge: Inter is ill-behaved on the empty set *)
val prems = goal set_thy
    "[| a:A;  b:B |] ==> Inter(A Un B) = Inter(A) Int Inter(B)";
by (cut_facts_tac prems 1);
by (fast_tac eq_cs 1);
val Inter_Un_distrib = result();

(** Unions and Intersections of Families **)

goal set_thy "A Int Union(B) = (UN C:B. A Int C)";
by (fast_tac eq_cs 1);
val Int_Union_RepFun = result();


(** Devlin, page 12: Union of a family of unions **)

goal set_thy "(UN x:C. A(x) Un B(x)) = (UN x:C. A(x))  Un  (UN x:C. B(x))";
by (fast_tac eq_cs 1);
val Un_Union_RepFun = result();

val prems = goal set_thy "b:B ==> A Un Inter(B) = (INT C:B. A Un C)";
by (cut_facts_tac prems 1);
by (fast_tac eq_cs 1);
val Un_Inter_RepFun = result();

val prems = goal set_thy
    "c:C ==> (INT x:C. A(x)  Int  B(x)) = (INT x:C. A(x)) Int (INT x:C. B(x))";
by (cut_facts_tac prems 1);
by (fast_tac eq_cs 1);
val Int_Inter_RepFun = result();
