(*  Title: 	ZF/domrange
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Domain, range of a relation or function
*)

(*** domain ***)

val [prem] = goalw set_thy [domain_def,Pair_def] "<a,b>: r ==> a : domain(r)";
by (fast_tac (upair_cs addIs [prem]) 1);
val domainI = result();

val major::prems = goalw set_thy [domain_def]
    "[| a : domain(r);  !!y. <a,y>: r ==> P |] ==> P";
br (major RS CollectE) 1;
be exE 1;
by (REPEAT (ares_tac prems 1));
val domainE = result();

val [prem] = goal set_thy "b:B ==> domain(A*B) = A";
by (REPEAT (eresolve_tac [domainE,SigmaE2] 1
     ORELSE ares_tac [prem,domainI,equalityI,subsetI,SigmaI] 1));
val domain_not_mt = result();

goal set_thy "domain(0) = 0";
by (REPEAT (eresolve_tac [domainE,emptyE] 1
     ORELSE ares_tac [equalityI,subsetI] 1));
val domain_empty = result();

goal set_thy "domain(Sigma(A,B)) <= A";
br subsetI 1;
be domainE 1;
by (etac SigmaE2 1);
ba 1;
val domain_subset = result();


(*** range ***)

val [prem] = goalw set_thy [range_def,Pair_def] "<a,b>: r ==> b : range(r)";
by (fast_tac (upair_cs addIs [prem]) 1);
val rangeI = result();

val major::prems = goalw set_thy [range_def]
    "[| b : range(r);  !!x. <x,b>: r ==> P |] ==> P";
br (major RS CollectE) 1;
be exE 1;
by (REPEAT (ares_tac prems 1));
val rangeE = result();

val [prem] = goal set_thy "a:A ==> range(A*B) = B";
by (REPEAT (eresolve_tac [rangeE,SigmaE2] 1
     ORELSE ares_tac [prem,rangeI,equalityI,subsetI,SigmaI] 1));
val range_not_mt = result();

goal set_thy "range(0) = 0";
by (REPEAT (eresolve_tac [rangeE,emptyE] 1
     ORELSE ares_tac [equalityI,subsetI] 1));
val range_empty = result();

goal set_thy "range(A*B) <= B";
br subsetI 1;
be rangeE 1;
by (etac SigmaE2 1);
ba 1;
val range_subset = result();


(*** field ***)

val [prem] = goalw set_thy [field_def] "<a,b>: r ==> a : field(r)";
br (prem RS domainI RS UnI1) 1;
val fieldI1 = result();

val [prem] = goalw set_thy [field_def] "<a,b>: r ==> b : field(r)";
br (prem RS rangeI RS UnI2) 1;
val fieldI2 = result();

val [prem] = goalw set_thy [field_def]
    "(~ <c,a>:r ==> <a,b>: r) ==> a : field(r)";
br (prem RS domainI RS UnCI) 1;
by (swap_res_tac [rangeI] 1);
be notnotE 1;
ba 1;
val fieldCI = result();

val major::prems = goalw set_thy [field_def]
     "[| a : field(r);  \
\        !!x. <a,x>: r ==> P;  \
\        !!x. <x,a>: r ==> P        |] ==> P";
br (major RS UnE) 1;
by (REPEAT (eresolve_tac (prems@[domainE,rangeE]) 1));
val fieldE = result();

goal set_thy "field(A*A) <= A";
br subsetI 1;
be fieldE 1;
by (REPEAT (eresolve_tac [asm_rl, SigmaE2] 1));
val field_subset = result();

goalw set_thy [field_def] "domain(r) <= field(r)";
by (rtac Un_upper1 1);
val domain_in_field = result();

goalw set_thy [field_def] "range(r) <= field(r)";
by (rtac Un_upper2 1);
val range_in_field = result();

val [prem] = goal set_thy "r <= Sigma(A,B) ==> r <= field(r)*field(r)";
by (rtac subsetI 1);
br (prem RS subsetD RS SigmaE) 1;
ba 1;
by (hyp_subst_tac 1);
br SigmaI 1;
be fieldI1 1;
be fieldI2 1;
val field_times_field = result();


(*** Image of a set under a function/relation ***)

val prems = goalw set_thy [image_def] "[| <a,b>: r;  a:A |] ==> b : r``A";
by (REPEAT (resolve_tac (prems @ [bexI,CollectI,rangeI]) 1));
val imageI = result();

val major::prems = goalw set_thy [image_def]
    "[| b: r``A;  !!x.[| <x,b>: r;  x:A |] ==> P |] ==> P"; 
br (major RS CollectE) 1;
by (REPEAT (etac bexE 1 ORELSE ares_tac prems 1));
val imageE = result();

val prems = goal set_thy "[| r <= A*B;  C<=A |] ==> r``C <= B";
by (cut_facts_tac prems 1);
by (rtac subsetI 1);
by (REPEAT (eresolve_tac [asm_rl, imageE, subsetD RS SigmaE2] 1));
val image_subset = result();


(*** Inverse image of a set under a function/relation ***)

val prems = goalw set_thy [vimage_def] "[| <a,b>: r;  b:B |] ==> a : r-``B";
by (REPEAT (resolve_tac (prems @ [bexI,CollectI,domainI]) 1));
val vimageI = result();

val major::prems = goalw set_thy [vimage_def]
    "[| a: r-``B;  !!x.[| <a,x>: r;  x:B |] ==> P |] ==> P"; 
br (major RS CollectE) 1;
by (REPEAT (etac bexE 1 ORELSE ares_tac prems 1));
val vimageE = result();

val prems = goal set_thy "[| r <= A*B;  C<=B |] ==> r-``C <= A";
by (cut_facts_tac prems 1);
by (rtac subsetI 1);
by (REPEAT (eresolve_tac [asm_rl, vimageE, subsetD RS SigmaE2] 1));
val vimage_subset = result();


(** The Union of a set of relations is a relation -- Lemma for fun_Union **)
val prems = goal set_thy
    "[| !!x. x:S ==> EX A B. x <= A*B |] ==>  \
\    Union(S) <= domain(Union(S)) * range(Union(S))";
by (rtac subsetI 1);
by (etac UnionE 1);
by (rtac exE 1);
by (REPEAT (eresolve_tac (prems@[exE,SigmaE]) 1 ORELSE set_mp_tac 1));
by (hyp_subst_tac 1);
by (REPEAT (ares_tac [SigmaI,domainI,rangeI,UnionI] 1));
val rel_Union = result();

(** The Union of 2 relations is a relation (Lemma for fun_Un)  **)
val prems = goal set_thy
    "[| r <= A*B;  s <= C*D |] ==>  \
\    (r Un s) <= (A Un C) * (B Un D)";
by (cut_facts_tac prems 1);
by (REPEAT (contr_tac 1 
     ORELSE eresolve_tac [UnE,SigmaE,ssubst] 1 
     ORELSE set_mp_tac 1 
     ORELSE ares_tac [subsetI,SigmaI,UnCI] 1));
val rel_Un = result();


(** Theorem-proving for ZF set theory **)

val ZF_cs = upair_cs 
    addSIs [SigmaI]
    addIs [imageI, vimageI, domainI, rangeI, fieldCI]
    addSEs [SigmaE2, SigmaE, Pair_inject, make_elim succ_inject,
	    imageE, vimageE, 
	    domainE, rangeE, fieldE]
    addEs [Pair_neq_0, sym RS Pair_neq_0, 
	   succ_neq_0, sym RS succ_neq_0];

fun cfast_tac prems = cut_facts_tac prems THEN' fast_tac ZF_cs;

