(*  Title: 	NJ
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Compatibility file for Standard ML of New Jersey, version 0.66.
*)

(*To exit the system -- an alternative to ^D *)
val quit = System.Unsafe.CInterface.exit;

(*To change the current directory*)
val cd = System.Directory.cd;

(*To limit the printing depth [divided by 2 for comparibility with Poly/ML]*)
fun print_depth n = (System.Control.Print.printDepth := n div 2;
		     System.Control.Print.printLength := n);

(*Only works in Poly/ML at present*)
fun install_pp f = ();

(* This parameter setting depends upon how much memory you have!!! *)
System.Control.Runtime.softmax := 10000000;

(* Suppresses Garbage Collection messages;  default was 2 *)
System.Control.Runtime.gcmessages := 0;

(*redefine to flush its output immediately -- temporary patch suggested
  by Kim Dam Petersen*)
val output = fn(s,t) => (output(s,t); flush_out s);

(*A conditional timing function: applies f to () and, if the flag is true,
  prints its runtime. *)
fun cond_timeit flag f =
  if flag then
    let open System.Timer;
	val start = start_timer()
	val result = f();
	val nongc = check_timer(start)
	and gc = check_timer_gc(start);
	val both = add_time(nongc,gc)
    in  print("Non GC "^ makestring nongc ^
	      "   GC "^ makestring gc ^
	      "   both "^ makestring both ^ " secs\n");
	result
    end
  else f();

(*Unconditional timing function*)
val timeit = cond_timeit true;
