(*  Title: 	HOL/set.ML
    Author: 	Tobias Nipkow, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Cantor's Theorem; the Schroeder-Berstein Theorem.  
*)


(* Cantor's Theorem: There is no surjection from a set to its powerset. *)

val [major] = goal HOL_Rule.thy "P = (~P) ==> False";
br (major RS iffE) 1;
by (fast_tac HOL_cs 1);
val P_not_PE = result();

goal HOL_Rule.thy "~ (? f:: ['a,'a]=>bool. ! S. ? a. f(a) = S)";
by (EVERY1 [rtac notI, etac exE, etac allE, etac exE,
	    rtac P_not_PE, etac ap_thm]);
val cantor1 = result();

(*This version displays the diagonal term*)
goal HOL_Rule.thy "~ (? a. f(a) = ?S(f:: 'a=>'a=>bool))";
by (EVERY1 [rtac notI, etac exE, rtac P_not_PE, etac ap_thm]);
uresult();

(*Cantor's Theorem in terms of classes -- proof needs this big hint...*) 
val [major] = goal Class.thy "f(a) = {x. ~x:f(x)} ==> False";
br (major RS equalityE) 1;
by (fast_tac class_cs 1);
val diag_lemma = result();

goal Class.thy "~ (? f:: 'a=>'a class. ! S. ? a. f(a) = S)";
by (fast_tac (HOL_cs addEs [diag_lemma]) 1);
val cantor2 = result();


(*** The Schroder-Berstein Theorem ***)

val prems = goalw Fixedpt.thy [image_def] "One_One(f) ==> Inv(f)``(f``X) = X";
by (cut_facts_tac prems 1);
br equalityI 1;
by (fast_tac (class_cs addEs [Inv_f_f RS ssubst]) 1);
by (fast_tac (class_cs addEs [Inv_f_f RS ssubst]) 1);
val inv_image_comp = result();

val prems = goal Class.thy "~ f(a) : (f``X) ==> ~ a:X";
by (cfast_tac prems 1);
val contra_imageI = result();

goal Fixedpt.thy "(~ a : Compl(X)) = (a:X)";
by (fast_tac class_cs 1);
val not_Compl = result();

(*Lots of backtracking in this proof...*)
val [compl,fg,Xa] = goal Fixedpt.thy
    "[| Compl(f``X) = g``Compl(X);  f(a)=g(b);  a:X |] ==> b:X";
by (EVERY1 [rtac (not_Compl RS subst), rtac contra_imageI,
	    rtac (compl RS subst), rtac (fg RS subst), stac not_Compl,
	    rtac imageI, rtac Xa]);
val disj_lemma = result();

goal Fixedpt.thy "range(%z. z:X => f(z) | g(z)) = f``X Un g``Compl(X)";
br equalityI 1;
bw range_def;
by (fast_tac (class_cs addIs [if_P RS sym, if_not_P RS sym]) 2);
br subsetI 1;
be CollectE 1;
be exE 1;
be ssubst 1;
br (excluded_middle RS disjE) 1;
by (EVERY' [rtac (if_P     RS ssubst), atac, fast_tac class_cs] 2);
by (EVERY' [rtac (if_not_P RS ssubst), atac, fast_tac class_cs] 1);
val range_if_then_else = result();

goal Fixedpt.thy "a : X Un Compl(X)";
by (fast_tac class_cs 1);
val X_Un_Compl = result();

goalw Fixedpt.thy [Onto_def] "Onto(f) = (!a. a : range(f))";
by (fast_tac (class_cs addEs [ssubst]) 1);
val Onto_iff_full_range = result();

val [compl] = goal Fixedpt.thy
    "Compl(f``X) = g``Compl(X) ==> Onto(%z. z:X => f(z) | g(z))";
by (sstac [Onto_iff_full_range, range_if_then_else, compl RS sym] 1);
by (rtac (X_Un_Compl RS allI) 1);
val surj_if_then_else = result();

val [injf,injg,compl,bij] = goal Fixedpt.thy
    "[| One_One_on(f,X);  One_One_on(g,Compl(X));  Compl(f``X) = g``Compl(X); \
\       bij = (%z. z:X => f(z) | g(z)) |] ==> \
\       One_One(bij) & Onto(bij)";
val f_eq_gE = make_elim (compl RS disj_lemma);
br (bij RS ssubst) 1;
br conjI 1;
by (rtac (compl RS surj_if_then_else) 2);
bw One_One_def;
by (cut_facts_tac [injf,injg] 1);
by (EVERY1 [rtac allI, rtac allI, stac expand_if, rtac conjI, stac expand_if]);
by (fast_tac (class_cs addEs  [One_One_onD, sym RS f_eq_gE]) 1);
by (stac expand_if 1);
by (fast_tac (class_cs addEs  [One_One_onD, f_eq_gE]) 1);
val bij_if_then_else = result();

goal Fixedpt.thy "? X. X = Compl(g``Compl(f:: 'a=>'b``X))";
br exI 1;
br Tarski_theorem 1;
by (REPEAT (ares_tac [monoI, image_mono, Compl_anti_mono] 1));
val decomposition = result();

val [injf,injg] = goal Fixedpt.thy
   "[| One_One(f:: 'a=>'b);  One_One(g:: 'b=>'a) |] ==> \
\   ? h:: 'a=>'b. One_One(h) & Onto(h)";
by (rtac (decomposition RS exE) 1);
fr exI;
by (rtac bij_if_then_else 1);
by (EVERY [rtac refl 4, rtac (injf RS One_One_imp) 1,
	   rtac (injg RS One_One_on_Inv) 1]);
by (EVERY1 [etac ssubst, stac double_complement, rtac subsetI,
	    etac imageE, etac ssubst, rtac rangeI]);
by (EVERY1 [etac ssubst, stac double_complement, 
	    rtac (injg RS inv_image_comp RS sym)]);
val schroeder_bernstein = result();
