(*  Title: 	HOL/ruleshell
    Author: 	Tobias Nipkow
    Copyright   1990  University of Cambridge

Natural Deduction Rules for Higher-order logic 

After updating, rebuild  ".rules.ML"  by calling   "make-rulenames"   
*)


signature HOL_RULE =
  sig
  val sign: Sign.sg
  val thy: theory
(*INSERT-RULESIG -- file produced by make-rulenames*)
  val refl: thm
  val subst: thm
  val abs: thm
  val disch: thm
  val mp: thm
  val True_def: thm
  val All_def: thm
  val Ex_def: thm
  val False_def: thm
  val not_def: thm
  val and_def: thm
  val or_def: thm
  val Ex1_def: thm
  val iff: thm
  val True_or_False: thm
  val select: thm
  val Inv_def: thm
  val o_def: thm
  val I_def: thm
  val Cond_def: thm
  end;


functor HOL_RuleFun () : HOL_RULE = 
struct

local open Syntax
in

val mixfix =
 [Mixfix("(_)",	"bool => prop",	"Trueprop", [0], 5),
      (*Primitive Constants*)
  Infixl("=",	"['a,'a] => bool", 		50),
  Infixr("-->",	"[bool,bool] => bool", 		25),
  Binder("@",	"'a", "bool", "'a", "Eps", 0, 	10),
      (* Defined Constants *)
  Infixr("o",	"['b=>'c, 'a=>'b, 'a] => 'c", 	50),
  Mixfix("(_ =>/ (_ |/ _))", "[bool,'a,'a] => 'a", "Cond", [41,40,40], 40),
  Mixfix("~_",	"bool => bool",	"not", [40],	40),
  Infixr("&",	"[bool,bool] => bool", 		35),
  Infixr("|",	"[bool,bool] => bool", 		30),
  Binder("! ",	"'a", "bool", "bool", "All", 0, 10),
  Binder("? ",	"'a", "bool", "bool", "Ex", 0, 	10),
  Binder("?! ",	"'a", "bool", "bool", "Ex1", 0, 10)
  ];

val sext = Sext{mixfix=mixfix,
		parse_translation = [],
		print_translation = []};

val const_decs =
[ (["True","False"], "bool"),
  (["I"], "'a => 'a"),
  (["Inv"], "('a => 'b)  =>  ('b => 'a)")
];

end;

val thy = extend_theory pure_thy "HOL"
([("term",["logic"])],
 [(["fun"], (["term","term"],"term"))],
 [(["bool"],([],"term"))],
 const_decs,
 Some(sext))
[
  (*Basic Rules*)

  ("refl",	"t = t::'a"  ),
  ("subst",	"[| s = t; P(s) |] ==> P(t::'a)"  ),
  ("abs",	"(!!x::'a. f(x)::'b = g(x)) ==> (%x.f(x)) = (%x.g(x))"  ),

  ("disch",	"(P ==> Q) ==> P-->Q"  ),
  ("mp",	"[| P-->Q;  P |] ==> Q"  ),

  (* Definitions *)

  ("True_def",	"True = ((%x.x)=(%x.x))"  ),
  ("All_def",	"All  = (%P. P = (%x.True))"  ),
  ("Ex_def",	"Ex   = (%P. P(Eps(P)))"  ),
  ("False_def",	"False = (!P.P)"  ),
  ("not_def",	"not  = (%P. P-->False)"  ),
  ("and_def",	"op & = (%P Q. !R. (P-->Q-->R) --> R)"  ),
  ("or_def",	"op | = (%P Q. !R. (P-->R) --> (Q-->R) --> R)"  ),
  ("Ex1_def",	"Ex1 == (%P. ? x. P(x) & (! y. P(y) --> y=x))"  ),

  (* Axioms*)

  ("iff",	"(P-->Q) --> (Q-->P) --> (P=Q)" ),
  ("True_or_False",	"(P=True) | (P=False)"  ),
  ("select",	"P(x::'a) --> P(Eps(P))"  ),

  (*Misc Definitions*)

  ("Inv_def",	"Inv = (%(f::'a=>'b) y. @x. f(x)=y)"  ),
  ("o_def",	"op o = (%(f::'b=>'c) g (x::'a). f(g(x)))"  ),
  ("I_def",	"I = (%x::'a.x)"  ),

  ("Cond_def",	
   "Cond = (%P x y.@z::'a. (P=True --> z=x) & (P=False --> z=y))" )
];

val sign = sign_of thy;
val ax = get_axiom thy;

(*INSERT-RULENAMES -- file produced by make-rulenames*)
val refl = ax"refl";
val subst = ax"subst";
val abs = ax"abs";
val disch = ax"disch";
val mp = ax"mp";
val True_def = ax"True_def";
val All_def = ax"All_def";
val Ex_def = ax"Ex_def";
val False_def = ax"False_def";
val not_def = ax"not_def";
val and_def = ax"and_def";
val or_def = ax"or_def";
val Ex1_def = ax"Ex1_def";
val iff = ax"iff";
val True_or_False = ax"True_or_False";
val select = ax"select";
val Inv_def = ax"Inv_def";
val o_def = ax"o_def";
val I_def = ax"I_def";
val Cond_def = ax"Cond_def";

end;
