(*  Title: 	FOL/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Adds First-Order Logic to a database containing pure Isabelle. 
Should be executed in the subdirectory FOL.
*)

writeln"Root file for First-Order Logic";

print_depth 1;  
use ".rules.ML";
use "int-prover.ML";
use "cla-lemmas.ML";
use "../Provers/hypsubst.ML";
use "../Provers/classical.ML";

structure Int_Rule = Int_RuleFun();
structure Int_Prover = Int_ProverFun(Int_Rule);
structure Cla_Lemmas = 
     Cla_LemmasFun(structure Int_Rule=Int_Rule and Int_Prover=Int_Prover);

open Int_Rule Int_Prover Cla_Lemmas;


(*** Applying HypsubstFun to generate hyp_subst_tac ***)

structure Hypsubst_Data =
  struct
  (*Take apart an equality judgement; otherwise raise Match!*)
  fun dest_eq (Const("Trueprop",_) $ (Const("op =",_)  $ t $ u)) = (t,u);

  val imp_intr = impI

  (*etac rev_cut_eq moves an equality to be the last premise. *)
  val rev_cut_eq = prove_goal Int_Rule.thy "[| a=b;  a=b ==> R |] ==> R"
   (fn prems => [ REPEAT(resolve_tac prems 1) ]);

  val rev_mp = rev_mp
  val subst = subst
  val sym = sym
  end;

structure Hypsubst = HypsubstFun(Hypsubst_Data);
open Hypsubst;

(*** Applying ClassicalFun to create a classical prover ***)
structure Classical_Data = 
  struct
  val size_of_thm = size_of_thm
  val imp_elim = impE
  val not_elim = notE
  val swap = swap
  val hyp_subst_tacs=[hyp_subst_tac]
  end;

structure Classical = ClassicalFun(Classical_Data);
open Classical;

(*Propositional rules*)
val prop_cs = empty_cs addSIs [TrueI,conjI,disjCI,impI,notI,iffI] addIs [refl] 
                       addSEs [conjE,disjE,impCE,FalseE,iffE];

(*Quantifier rules*)
val FOL_cs = prop_cs addSIs [allI] addIs [exI,ex1I] addXIs [exCI] 
                     addSEs [exE,ex1E] addEs [allE];

use "../Provers/simp.ML";
use "../Provers/ind.ML";
use "simpdata.ML";

print_depth 6;

(* Set up automatic printing of theorems -- works in Poly/ML only *)
install_pp (K print_thm);

