(*  Title: 	CUBE/syntax
    Author: 	Tobias Nipkow
    Copyright   1990  University of Cambridge

*)


signature CUBE_SYNTAX =
  sig
  val const_decs: (string list * string) list
  val sext: Syntax.sext
  end;

functor CUBE_SyntaxFun () : CUBE_SYNTAX = 
struct
local open Syntax
in

fun qnt_tr q [Free(a,T),A,B] = Const(q,dummyT) $ A $ absfree(a,T,B);

fun qnt_tr' q [t1,Abs(a,T,t2')] =
let val (a',t2) = variant_abs(a,T,t2')
in Const(q,dummyT) $ Free(a',T) $ t1 $ t2 end;

fun fun_tr[A,B] =
	Const("Prod",dummyT) $ A $ Abs("x",dummyT,incr_boundvars 1 B);

fun fun_tr'[A,Abs(id,T,B)] =
    if 0 mem (loose_bnos B)
    then 
      let val (id',B') = variant_abs(id,T,B)
      in Const("Pi",dummyT) $ Free(id',T) $ A $ B' end
    else Const("op ->",dummyT) $ A $ B;

fun no_asms_tr[t] = Const("Trueprop",dummyT)$Const("MT_context",dummyT)$t;
fun no_asms_tr'[Const("MT_context",_),t] = Const("Trueprop1",dummyT)$t;

val mixfix =
[Delimfix("(_/|- _)", "[context,typing] => prop", "Trueprop"),
 Delimfix("(_)", "typing => prop", "Trueprop1"),
 Delimfix("", "context", "MT_context"),
 Delimfix("_ ", "ID  => context", ""),
 Delimfix("_ ", "VAR => context", ""),
 Delimfix("_ _", "[typing,context] => context", "Context"),
 Delimfix("*", "term", "star"),
 Delimfix("[]", "term", "box"),
 Infixl("^", "[term,term] => term", 20),
 Mixfix("(2Lam _:_./ _)", "[ID,term,term] => term", "Lam", [0,0,0], 10),
 Mixfix("(2Pi _:_./ _)",  "[ID,term,term] => term", "Pi", [0,0], 10),
 Infixr("->", "[term,term] => term", 10),
 Mixfix("(_:/ _)", "[term,term] => typing",  "Has_type", [0,0], 5)
];

val sext = Sext{mixfix=mixfix,
parse_translation = [("Lam", qnt_tr "Abs"), ("Pi", qnt_tr "Prod"),
	("op ->", fun_tr), ("Trueprop1",no_asms_tr)],
print_translation = [("Abs", qnt_tr' "Lam"), ("Prod", fun_tr'),
	("Trueprop",no_asms_tr')]};

val const_decs = [(["Abs","Prod"], "[term, term=>term] => term")];

end;
end;
