(*  Title: 	HOL/types
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1990  University of Cambridge

Derived rules from Appendix B of Mike Gordons HOL Report, Cambridge TR 68 

Printer.show_types:=true;
Printer.show_types:=false;
Printer.show_sorts:=true;
Printer.show_sorts:=false;
*)

use"/usr/users/lcp/isa/shortcuts.ML";

val T_intr = truth
and conj_intr = conj
and conj_elim1 = conjunct1
and conj_elim2 = conjunct2
and disj_intr1 = disj1
and disj_intr2 = disj2
and disj_elim = disj_cases
and imp_intr = disch
and all_intr = gen
and exists_intr = exists
and exists_elim = choose;


val prems = 
goal thy "P&Q ==> ([| P;  Q |] ==> R) ==> R";
by (cut_facts_tac prems 1);
brs prems 1;
be conj_elim1 1;
be conj_elim2 1;
val conj_elim = result();


val prems = goal thy "P(x$$'a) ==> P(@x. P(x))";
br mp 1;
br eps 1;
brs prems 1;
val eps_intr = result();


fun defsubst aty def = 
    def RS read_instantiate(sign_of thy)[("'a",aty)] (sym RS subst);

val prems = 
goal thy "[| P(t$$'a);  !x. P(x) ==> x=t |] ==> ?!x.P(x)";
br (defsubst "('a=>bool)=>bool" Ex1_def) 1;
br conj_intr 1;
br exists_intr 1;
brs prems 1;
br all_intr 1;
br all_intr 1;
br imp_intr 1;
be conj_elim 1;
br trans 1;
bes prems 1;
br sym 1;
bes prems 1;
val ex1_intr = result();

val pthy = extend_theory thy "Pairs"
([],[],
 [(["Mk_Pair"], "'a => 'b => ('a => 'b => bool)"),
  (["Is_Pair"], "('a => 'b => bool) => bool"),
  (["fst"], "('a => 'b => bool) => 'a"),
  (["snd"], "('a => 'b => bool) => 'b")
])
[("Mk_Pair_def",  "Mk_Pair = (%a b. %x y. x=a & y=b)"),
 ("Is_Pair_def",  "Is_Pair = (%f. ??a b. f = Mk_Pair(a,b))"),
 ("fst_def",  "fst = (%f. @x. ??y. f = Mk_Pair(x,y))"),
 ("snd_def",  "snd = (%f. @y. ??x. f = Mk_Pair(x,y))")
];

val Is_Pair_def = (get_axiom pthy) "Is_Pair_def";
val Mk_Pair_def = (get_axiom pthy) "Mk_Pair_def";
val fst_def = (get_axiom pthy) "fst_def";
val snd_def = (get_axiom pthy) "snd_def";

goal pthy "??f. Is_Pair(f)";
br (defsubst "('a=>'b=>bool)=>bool" Is_Pair_def) 1;
br (defsubst "'a=>'b=>'a=>'b=>bool" Mk_Pair_def) 1;
by (res_inst_tac[("'a","'a=>'b=>bool")] exists_intr 1);
br exists_intr 1;
br exists_intr 1;
by (res_inst_tac[("'a","'a=>'b=>bool")] refl 1);
val pair_nonempty = result();


val prems = 
goal pthy "Mk_Pair(a, b) = Mk_Pair(a',b') --> a=a' & b=b'";
br (defsubst "'a => 'b => ('a=>'b=>bool)" Mk_Pair_def) 1;
br imp_intr 1;
br cut_rl 1;
by (eres_inst_tac [("'b","'b=>bool")] ap_thm 2);
br cut_rl 1;
by (eres_inst_tac [("'a","'b")] ap_thm 2);
be subst 1;
br conj_intr 1;
br refl 1;
br refl 1;
val pairing_unique_lemma = result();


val prems = 
goal pthy "Mk_Pair(a, b) = Mk_Pair(a',b') ==> ([| a=a';  b=b' |] ==> R) ==> R";
br conj_elim 1;
br mp 1;
br pairing_unique_lemma 1;
brs prems 1;
brs prems 1;
ba 1;
ba 1;
val pairing_unique = result();


goal pthy "??y. Mk_Pair(a$$'a,b$$'b) = Mk_Pair(fst(Mk_Pair(a,b)), y)";
br (defsubst "('a=>'b=>bool)=>'a" fst_def) 1;
br eps_intr 1;
br exists_intr 1;
by (res_inst_tac[("'a","'a=>'b=>bool")] refl 1);
val fst_lemma = result();

goal pthy "fst(Mk_Pair(a,b)) = a";
br exists_elim 1;
br fst_lemma 1;
be pairing_unique 1;
be sym 1;
val fst_conv = result();


goal pthy "??x. Mk_Pair(a$$'a, b$$'b) = Mk_Pair(x, snd(Mk_Pair(a,b)))";
br (defsubst "('a=>'b=>bool)=>'b" snd_def) 1;
br eps_intr 1;
br exists_intr 1;
by (res_inst_tac[("'a","'a=>'b=>bool")] refl 1);
val snd_lemma = result();

goal pthy "snd(Mk_Pair(a,b)) = b";
br exists_elim 1;
br snd_lemma 1;
be pairing_unique 1;
be sym 1;
val snd_conv = result();


goal pthy "Is_Pair(f)  --> f = Mk_Pair(fst(f),snd(f))";
br (defsubst "('a=>'b=>bool)=>bool" Is_Pair_def) 1;
br imp_intr 1;
be exists_elim 1;
be exists_elim 1;
by (eres_inst_tac[("'a","'a=>'b=>bool")] (sym RS subst) 1);
br (fst_conv RS sym RS subst) 1;
br (snd_conv RS sym RS subst) 1;
by (res_inst_tac[("'a","'a=>'b=>bool")] refl 1);
val surjective_pairing = result();

