(*  Title: 	HOL/ex/equal
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Classical HOL: simplification and equality

by (Pc.onestep_tac 1);
by (Pc.step_tac asms 1);
by (Pc.comp_step_tac asms);
by (Pc.comp_tac asms);
*)


val asms =
goal HOL_Rule.thy
    "[| a:A; b:B; c:C |] ==> fst(snd(<a,<b,c>>)) = snd(fst(<<a,b>,c>)) :?A";
by (rew_tac asms);
uresult();

(*in the "rec" formulation of addition, 0+n=n *)
val asms =
goal HOL_Rule.thy "a:nat ==> rec(a,0, %y z.Succ(y)) = a :nat";
by (nat_induct_tac "a" 1);
by (rew_tac asms);
result();

(*the harder version, n+0=n: recursive, uses induction hypothesis*)
val asms =
goal HOL_Rule.thy "a:nat ==> rec(a,0, %y z.Succ(z)) = a : nat";
by (nat_induct_tac "a" 1);
by (hyp_rew_tac asms);
result();

(*Associativity of addition*)
val asms =
goal HOL_Rule.thy "[| a: nat;  b: nat;  c: nat |] ==> \
\    rec(rec(a, b, %x y.Succ(y)), c, %x y.Succ(y)) = \
\    rec(a, rec(b, c, %x y.Succ(y)), %x y.Succ(y)) : nat";
by (nat_induct_tac "a" 1);
by (hyp_rew_tac asms);
result();

writeln"Reached end of file.";

(*11 September 1988: loaded this file in 28 seconds*)
