(*  Title: 	NJ/ex/prop
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Intuitionistic FOL: examples with propositional connectives

This entire file can be loaded to test the NJ system.


Single-step commands:

by (step_tac 1);
by (biresolve_tac safe_brls 1);
by (biresolve_tac unsafe_brls 1);
by (assume_tac 1);
by (safe_tac 1);
by (mp_tac 1);
by (pc_tac 1);
*)

writeln"Simple propositional examples";


(*A test of mp_tac *)
goal NJ_Rule.thy "[| (P --> Q) & P --> Q |]";
by (safe_tac 1);
result();

goal NJ_Rule.thy "[| P --> P & P |]";
by (safe_tac 1);
result();


writeln"commutative laws of & and | ";
goal NJ_Rule.thy "[| P & Q  -->  Q & P |]";
by (safe_tac 1);
result();

goal NJ_Rule.thy "[| P | Q  -->  Q | P |]";
by (pc_tac 1);
result();


writeln"associative laws of & and | ";
goal NJ_Rule.thy "[| (P & Q) & R  -->  P & (Q & R) |]";
by (safe_tac 1);
result();

goal NJ_Rule.thy "[| (P | Q) | R  -->  P | (Q | R) |]";
by (pc_tac 1);
result();



writeln"distributive laws of & and | ";
goal NJ_Rule.thy "[| (P & Q) | R  --> (P | R) & (Q | R) |]";
by (pc_tac 1);
result();

goal NJ_Rule.thy "[| (P | R) & (Q | R)  --> (P & Q) | R |]";
by (pc_tac 1);
result();

goal NJ_Rule.thy "[| (P | Q) & R  --> (P & R) | (Q & R) |]";
by (pc_tac 1);
result();


goal NJ_Rule.thy "[| (P & R) | (Q & R)  --> (P | Q) & R |]";
by (pc_tac 1);
result();


writeln"Laws involving implication";

goal NJ_Rule.thy "[| (P|Q --> R) --> (P-->R) & (Q-->R) |]";
by (pc_tac 1);
result();

goal NJ_Rule.thy "[| (P-->R) & (Q-->R) --> (P|Q --> R) |]";
by (pc_tac 1);
result();


goal NJ_Rule.thy "[| (P & Q --> R) <-> (P--> (Q-->R)) |]";
by (pc_tac 1);
result();


goal NJ_Rule.thy "[| ((P-->R)-->R) --> ((Q-->R)-->R) --> (P&Q-->R) --> R |]";
by (pc_tac 1);
result();

goal NJ_Rule.thy "[|  (~(P-->R)) --> (~(Q-->R)) --> ~(P&Q-->R) |]";
by (pc_tac 1);
result();

goal NJ_Rule.thy "[| (P --> Q & R) <-> (P-->Q)  &  (P-->R) |]";
by (pc_tac 1);
result();


writeln"Propositions-as-types";

(*The combinator K*)
goal NJ_Rule.thy "[| P --> (Q --> P) |]";
by (safe_tac 1);
result();

(*The combinator S*)
goal NJ_Rule.thy "[| (P-->Q-->R)  --> (P-->Q) --> (P-->R) |]";
by (pc_tac 1);
result();


(*Converse is classical*)
goal NJ_Rule.thy "[| (P-->Q) | (P-->R)  -->  (P --> Q | R) |]";
by (pc_tac 1);
result();

goal NJ_Rule.thy "[| (P-->Q)  -->  (~(Q) --> ~(P)) |]";
by (pc_tac 1);
result();

goal NJ_Rule.thy "[| ~ ~ ((P --> Q | R)  -->  (P-->Q) | (P-->R)) |]";
by (pc_tac 1);
result();

goal NJ_Rule.thy "[| (P<->Q) <-> (Q<->P) |]";
by (pc_tac 1);
result();


writeln"Lemmas for the propositional double-negation translation";

goal NJ_Rule.thy "[| P --> (~ ~ P) |]";
by (pc_tac 1);
result();

goal NJ_Rule.thy "[| ~ ~ ((~ ~ P) --> P) |]";
by (pc_tac 1);
result();

goal NJ_Rule.thy "[| (~ ~ P) & ~ ~ (P --> Q) --> (~ ~ Q) |]";
by (pc_tac 1);
result();

goal NJ_Rule.thy "[| ~ ~ ~ P --> ~ P |]";
by (pc_tac 1);
result();


(*The following are classically but not constructively valid.
  The attempt to prove them terminates quickly!*)
goal NJ_Rule.thy "[| ((P-->Q) --> P)  -->  P |]";
by (pc_tac 1) handle ERROR => writeln"Failed, as expected";  
(*Check that subgoals remain: proof failed.*)
get_goal 1;  

goal NJ_Rule.thy "[| (P&Q-->R)  -->  (P-->R) | (Q-->R) |]";
by (pc_tac 1) handle ERROR => writeln"Failed, as expected";  
get_goal 1;  

(*examples from The Foundation of a Generic Theorem Prover*)
goal NJ_Rule.thy "[| A&B  --> (C-->A&C) |]";
by (resolve_tac [imp_intr] 1);
by (resolve_tac [imp_intr] 1);
by (resolve_tac [conj_intr] 1);
by (assume_tac 2);
by (resolve_tac [conjunct1] 1);
by (assume_tac 1);
result();

val asms = 
goal NJ_Rule.thy "[| A&B |] ==> ([| A |] ==> [| B |] ==> [| C |]) ==> [| C |]";
by (resolve_tac asms 1);
by (resolve_tac [conjunct1] 1);
by (resolve_tac asms 1);
by (resolve_tac [conjunct2] 1);
by (resolve_tac asms 1);
result();


val asms = 
goal NJ_Rule.thy "(!(A)[| ~ (~A) |] ==> [| A |]) ==> [| B | ~B |]";
by (resolve_tac asms 1);
by (resolve_tac [imp_intr] 1);
by (res_inst_tac [ ("P", "~B", Aform) ]  mp  1);
by (resolve_tac [imp_intr] 2);
by (res_inst_tac [ ("P", "B | ~ B", Aform) ]  mp  2);
by (assume_tac 2);
by (resolve_tac [disj_intr1] 2);
by (assume_tac 2);
by (resolve_tac [imp_intr] 1);
by (res_inst_tac [ ("P", "B | ~ B", Aform) ]  mp  1);
by (assume_tac 1);
by (resolve_tac [disj_intr2] 1);
by (assume_tac 1);
result();



val asms = 
goal NJ_Rule.thy "[| A | ~A |] ==> [| ~(~A) |] ==> [| A |]";
by (resolve_tac [disj_elim] 1);
by (resolve_tac asms 1);
by (assume_tac 1);
by (resolve_tac [False_elim] 1);
by (res_inst_tac [ ("P", "~A", Aform) ]  mp  1);
by (resolve_tac asms 1);
by (assume_tac 1);
result();


writeln"Reached end of examples.";
(*21 August 88: loaded in 42 secs*)
