(*  Title: 	NJ/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Adds Intuitionistic First Order Logic to a database containing pure Isabelle. 
Should be executed in the subdirectory NJ.
*)

writeln"Root file for Intuitionistic First Order Logic";

open PolyML;  (*essential when using make_database!*)

print_depth 1;  
use "syntax.ML";
use ".rules.ML";
use "resolve.ML";

print_depth 1;  
structure NJ_Syntax = NJ_SyntaxFun(structure Syntax=Syntax and Pretty=Pretty);
structure NJ_Rule = NJ_RuleFun(structure NJ_Syntax=NJ_Syntax and Thm=Thm);
structure NJ_Resolve = NJ_ResolveFun
    (structure NJ_Syntax=NJ_Syntax and NJ_Rule=NJ_Rule and Conv=Conv);

print_depth 0;  
open Thm Tactic Goals Conv;
open NJ_Syntax NJ_Rule NJ_Resolve;

Unify.printer := Syntax.prin syn;

print_depth 8;  

(*On 9 May 1989: loaded ex/ROOT.ML, running on dunlin, with times
      247.9 real       142.4 user        11.1 sys  *)
