(*  Title: 	NJ/NEWROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

For NEW JERSEY compiler.

Adds Intuitionistic First Order Logic to a database containing pure Isabelle. 
Should be executed in the subdirectory NJ.
*)

writeln"Root file for Intuitionistic First Order Logic";

use "syntax.ML";
use ".rules.ML";
use "resolve.ML";

structure NJ_Syntax = NJ_SyntaxFun(structure Syntax=Syntax and Pretty=Pretty);
structure NJ_Rule = NJ_RuleFun(structure NJ_Syntax=NJ_Syntax and Thm=Thm);
structure NJ_Resolve = NJ_ResolveFun
    (structure NJ_Syntax=NJ_Syntax and NJ_Rule=NJ_Rule and Conv=Conv);

open Thm Tactic Goals Conv;
open NJ_Syntax NJ_Rule NJ_Resolve;

Unify.printer := Syntax.prin syn;


(exportML"EXEC";  print "Isabelle + NJ: Intuitionistic First Order Logic\n");

(*On 9 May 1989: loaded ex/ROOT.ML, running on smew, with times
      453.4 real       285.6 user        23.3 sys  *)
