(*  Title: 	HOL/rew
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Construction of simplifier*)

val union_type_rls =  [ Inl_type,Inr_type,when_type ];

val list_type_rls = [Nil_type,Cons_type];

val all_type_rls = type_rls @ union_type_rls @ list_type_rls;


val congr_rls =
    [Lambda_congr, when_congr, rec_congr] @
    make_congr_rules all_type_rls;

(*Break down <-> or do type checking*)
fun routine_tac rls asms = 
    (REPEAT1 o compat_resolve_tac (refl_iff::iff_congr_rls) 3)
    ORELSE'  determ_type_tac (asms@rls);

val conv_rls = 
  [ beta_conv,eta_conv,fst_conv,snd_conv,pair_conv,
    cond_convT,cond_convF,
    when_conv_Inl,when_conv_Inr,
    rec_conv0,rec_conv1];


(*Assumption (including a single forall quant) *)
val prove_cond_tac = eresolve_tac [asm_rl, spec];


(*Flexibility test*)
fun flex_left (Const("Trueprop",_) $ (Const("Eq",_) $ t $ u $ A)) =
	is_var (head_of t)
  | flex_left (Const("Reduce",_) $ t $ u) = is_var (head_of t)
  | flex_left _ = false;


print_depth 1;  

structure Simp_data: SIMP_DATA =
struct
  structure Tactic = Tactic
  val flex_left= flex_left 
  val refl= refl
  val sym= sym
  val trans= trans
  val refl_red= refl_red
  val trans_red= trans_red
  val red_if_equal= red_if_equal
  val default_rls = conv_rls
  val routine_tac = routine_tac all_type_rls  (*should use pc_tac?*)
end;

structure Simp = SimpFun (structure Logic=Logic and Simp_data=Simp_data);


(*Make a rewriting tactic from a normalization tactic*)
fun make_rew_tac ntac =
    TRYALL (resolve_tac [replace_iff])  THEN  ntac;

fun rew_tac asms = make_rew_tac
    (Simp.norm_tac(congr_rls, asms));

fun hyp_rew_tac asms = make_rew_tac
    (Simp.cond_norm_tac(prove_cond_tac, congr_rls, asms));
