(*  Title: 	CTT/ex/synth
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge
*)

writeln"Synthesis examples, using a crude form of narrowing";


writeln"This finds the functions fst and snd!";  (*Can try without fold_tac*)
goal CTT_Rule.thy "[| ?a : N*N --> N|]";
by (rewrite_tac basic_defs);
by (intr_tac[]);
by (resolve_tac elim_rls 1  THEN  assume_tac 1);
by (assume_tac 1 THEN fold_tac basic_defs);
uresult();
writeln"first solution is snd;  backtracking gives fst";
back();
uresult();
writeln"and there are no other solutions";
back() handle ERROR => writeln"Failed, as expected"; 


writeln"discovery of predecessor function";
goal CTT_Rule.thy 
 "[| ?a : SUM pred:?A .	Eq(N, pred`0, 0)	\
\		     *	PROD n:N. Eq(N, pred ` succ(n), n) |]";
by (rewrite_tac basic_defs);
by (intr_tac[]);
by eqintr_tac;
by (resolve_tac reduction_rls 3);
by (resolve_tac comp_rls 5);
by (rew_tac[]);
by (fold_tac basic_defs);
uresult();



writeln"the function fst as an element of a function type";
goal CTT_Rule.thy "[| ?a: SUM f:?A. PROD i:N. PROD j:N. Eq(N, f ` <i,j>, i) |]";
by (intr_tac[]);
by eqintr_tac;
by (resolve_tac reduction_rls 2);
by (resolve_tac comp_rls 4);
by (typechk_tac[]);
writeln"now put in N everywhere";
by (TRYALL (resolve_tac [N_form]));
by (fold_tac basic_defs);
uresult();



writeln"An interesting use of the eliminator, when";
(*The early implementation of unification caused non-rigid path in occur check
  See following example.*)
goal CTT_Rule.thy 
 "[| ?a : PROD i:N. Eq(?A, ?b(inl(i)), <0    ,   i>)  \
\  	          * Eq(?A, ?b(inr(i)), <succ(0), i>) |]";
by (rewrite_tac basic_defs);
by (intr_tac[]);
by eqintr_tac;
by (resolve_tac comp_rls 1);
by (rew_tac[]);
by (fold_tac basic_defs);
uresult();


(*Here we allow the type to depend on i.  
 This prevents the cycle in the first unification (no longer needed).  
 Requires flex-flex to preserve the dependence.
 Simpler still: make ?A into a constant type N*N.*)
goal CTT_Rule.thy 
 "[| ?a : PROD i:N. Eq(?A(i), ?b(inl(i)), <0   ,   i>)   \
\ 	         *  Eq(?A(i), ?b(inr(i)), <succ(0),i>) |]";



writeln"A tricky combination of when and split";
(*Now handled easily, but caused great problems once*)
goal CTT_Rule.thy 
 "[| ?a : PROD i:N. PROD j:N. Eq(?A, ?b(inl(<i,j>)), i)   \
\  	    	           *  Eq(?A, ?b(inr(<i,j>)), j) |]";
by (rewrite_tac basic_defs);
by (intr_tac[]); 
by eqintr_tac;
by (resolve_tac [ trans_elem RES Plus_comp_inl ] 1);
by (resolve_tac comp_rls 4); 
by (resolve_tac reduction_rls 7);
by (resolve_tac comp_rls 10);
by (typechk_tac[]); (*2 secs*)
by (TRYALL (resolve_tac [N_form]));
by (fold_tac basic_defs);
uresult();



(*similar but allows the type to depend on i and j*)
goal CTT_Rule.thy 
 "[| ?a : PROD i:N. PROD j:N. Eq(?A(i,j), ?b(inl(<i,j>)), i) \
\ 	    	          *   Eq(?A(i,j), ?b(inr(<i,j>)), j) |] ";

(*similar but specifying the type N simplifies the unification problems*)
goal CTT_Rule.thy
 "[| ?a : PROD i:N. PROD j:N. Eq(N, ?b(inl(<i,j>)), i)	\
\ 	    	          *   Eq(N, ?b(inr(<i,j>)), j) |]";




writeln"Deriving the addition operator";
goal CTT_Rule.thy 
  "[| ?c : PROD n:N. Eq(N, ?f(0,n), n)  \
\  	          *  PROD m:N. Eq(N, ?f(succ(m), n), succ(?f(m,n))) |]";
by (rewrite_tac basic_defs);
by (intr_tac[]);
by eqintr_tac;
by (resolve_tac comp_rls 1);
by (rew_tac[]);
by (fold_tac (arith_defs@basic_defs));
uresult();


writeln"The addition function -- using explicit lambdas";
goal CTT_Rule.thy 
  "[| ?c : SUM plus : ?A .  \
\  	 PROD x:N. Eq(N, plus`0`x, x)  \
\  	        *  PROD y:N. Eq(N, plus`succ(y)`x, succ(plus`y`x)) |]";
by (rewrite_tac basic_defs);
by (intr_tac[]);
by eqintr_tac;
by (resolve_tac [Simp.split_eqn] 3);
by (SELECT_GOAL (rew_tac[]) 4);
by (resolve_tac [Simp.split_eqn] 3);
by (SELECT_GOAL (rew_tac[]) 4);
by (resolve_tac comp_rls 3);
by (rew_tac[]); 
by (fold_tac (arith_defs@basic_defs));
uresult();


writeln"Reached end of file.";
(*28 August 1988: loaded this file in 73 seconds*)
(*3 September 1988: loaded this file (modified to call rew_tac) in 77 seconds*)
