(*  Title: 	NJ/ex/hard-prop
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Intuitionistic FOL: propositional problems based on Pelletier.

  F. J. Pelletier, 
  Seventy-Five Problems for Testing Automatic Theorem Provers,
  J. Automated Reasoning 2 (1986), 191-216.   

This entire file can be loaded to test the NJ system.


Single-step commands:

by (step_tac 1);
by (biresolve_tac safe_brls 1);
by (biresolve_tac unsafe_brls 1);
by (assume_tac 1);
by (safe_tac 1);
by (mp_tac 1);
by (pc_tac 1);
*)

writeln"Harder propositional examples";


writeln"Problem 1";
goal NJ_Rule.thy "[| ~ ~ ((P-->Q)  <->  (~Q --> ~P)) |]";
by (pc_tac 1);
result();
(*5 secs*)


writeln"Problem 2";
goal NJ_Rule.thy "[| ~ ~ (~ ~ P  <->  P) |]";
by (pc_tac 1);
result();
(*1 secs*)


writeln"Problem 3";
goal NJ_Rule.thy "[| ~(P-->Q) --> (Q-->P) |]";
by (pc_tac 1);
result();

writeln"Problem 4";
goal NJ_Rule.thy "[| ~ ~ ((~P-->Q)  <->  (~Q --> P)) |]";
by (pc_tac 1);
result();
(*9 secs*)

writeln"Problem 5";
goal NJ_Rule.thy "[| ~ ~ ((P|Q-->P|R) --> P|(Q-->R)) |]";
by (pc_tac 1);
result();
(*10 secs*)


writeln"Problem 6";
goal NJ_Rule.thy "[| ~ ~ (P | ~ P) |]";
by (pc_tac 1);
result();

writeln"Problem 7";
goal NJ_Rule.thy "[| ~ ~ (P | ~ ~ ~ P) |]";
by (pc_tac 1);
result();

writeln"8.  Peirce's law";
goal NJ_Rule.thy "[| ~ ~ (((P-->Q) --> P)  -->  P)  |]";
by (pc_tac 1);
result();

writeln"Problem 9";
goal NJ_Rule.thy "[| ((P|Q) & (~P|Q) & (P| ~Q)) --> ~ (~P | ~Q)  |]";
by (pc_tac 1);
result();
(*9 secs*)


writeln"Problem 10";
goal NJ_Rule.thy "[| (Q-->R) --> (R-->P&Q) --> (P-->(Q|R)) --> (P<->Q)  |]";
by (pc_tac 1);
result();

writeln"11.  Proved in each direction (incorrectly, says Pelletier!!) ";
goal NJ_Rule.thy "[| P<->P  |]";
by (safe_tac 1);

writeln"12.  Dijkstra's law  ";
goal NJ_Rule.thy "[| ~ ~ (((P <-> Q) <-> R)  -->  (P <-> (Q <-> R))) |]";
by (pc_tac 1);
result();
(*55 secs.  MUCH SLOWER THAN IT SHOULD BE!!*)

goal NJ_Rule.thy "[| ((P <-> Q) <-> R)  -->  ~ ~ (P <-> (Q <-> R)) |]";
by (pc_tac 1);
result();
(*23 secs*)

writeln"13.  Distributive law";
goal NJ_Rule.thy "[| P | (Q & R)  <-> (P | Q) & (P | R) |]";
by (pc_tac 1);
result();
(*9 secs*)

writeln"14";
goal NJ_Rule.thy "[| ~ ~ ((P <-> Q) <-> ((Q | ~P) & (~Q|P))) |]";
by (pc_tac 1);
result();
(*28 secs*)

writeln"15";
goal NJ_Rule.thy "[| ~ ~ ((P --> Q) <-> (~P | Q)) |]";
by (pc_tac 1);
result();
(*4 secs*)

writeln"16";
goal NJ_Rule.thy "[| ~ ~ ((P-->Q) | (Q-->P)) |]";
by (pc_tac 1);
result();
(*2.4 secs*)

(*17**********************
goal NJ_Rule.thy
  "[| ~ ~ (((P & (Q-->R))-->S) <-> ((~P | Q | S) & (~P | ~R | S))) |]";
by (pc_tac 1);    
DIDN'T TERMINATE**********)



writeln"Reached end of examples.";
(*21 August 88: loaded in 54 secs*)
